/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.meter.metrics;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsProvider
implements MetricsProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsProvider.class);
    private final MeterRegistry meterRegistry;
    private SystemMetrics systemMetrics;
    private long lastRefreshTime = 0L;
    private double lastSystemCpuUsage = 0.0;
    private double lastProcessCpuUsage = 0.0;
    private static final long SYSTEM_METRICS_REFRESH_INTERVAL = 1000L;

    public DefaultMetricsProvider(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public SystemMetrics getSystemMetrics() {
        if (System.currentTimeMillis() - this.lastRefreshTime < 1000L) {
            return this.systemMetrics;
        }
        double systemCpuUsage = this.meterRegistry.get("system.cpu.usage").gauge().value();
        if (Double.compare(systemCpuUsage, Double.NaN) == 0) {
            systemCpuUsage = this.lastSystemCpuUsage;
        } else {
            this.lastSystemCpuUsage = systemCpuUsage;
        }
        double processCpuUsage = this.meterRegistry.get("process.cpu.usage").gauge().value();
        if (Double.compare(processCpuUsage, Double.NaN) == 0) {
            processCpuUsage = this.lastProcessCpuUsage;
        } else {
            this.lastProcessCpuUsage = processCpuUsage;
        }
        double jvmHeapUsed = this.calculateTotalMemory(this.meterRegistry, "heap", "jvm.memory.used");
        double jvmNonHeapUsed = this.calculateTotalMemory(this.meterRegistry, "nonheap", "jvm.memory.used");
        double jvmHeapMax = this.calculateTotalMemory(this.meterRegistry, "heap", "jvm.memory.max");
        double jvmNonHeapMax = this.calculateTotalMemory(this.meterRegistry, "nonheap", "jvm.memory.max");
        double jvmMemoryUsed = jvmHeapUsed + jvmNonHeapUsed;
        double jvmMemoryMax = jvmHeapMax + jvmNonHeapMax;
        double jvmMemoryUsedPercentage = jvmMemoryMax > 0.0 ? jvmMemoryUsed / jvmMemoryMax : 0.0;
        long totalSystemMemory = OSUtils.getTotalSystemMemory();
        long systemMemoryAvailable = OSUtils.getSystemAvailableMemoryUsed();
        double diskToTalBytes = this.meterRegistry.get("disk.total").gauge().value();
        double diskFreeBytes = this.meterRegistry.get("disk.free").gauge().value();
        this.systemMetrics = SystemMetrics.builder().systemCpuUsagePercentage(systemCpuUsage).jvmCpuUsagePercentage(processCpuUsage).jvmMemoryUsed(jvmMemoryUsed).jvmMemoryMax(jvmMemoryMax).jvmHeapUsed(jvmHeapUsed).jvmHeapMax(jvmHeapMax).jvmNonHeapUsed(jvmNonHeapUsed).jvmNonHeapMax(jvmNonHeapMax).jvmMemoryUsedPercentage(jvmMemoryUsedPercentage).systemMemoryUsed(totalSystemMemory - systemMemoryAvailable).systemMemoryMax(totalSystemMemory).systemMemoryUsedPercentage((double)(totalSystemMemory - systemMemoryAvailable) / (double)totalSystemMemory).diskUsed(diskToTalBytes - diskFreeBytes).diskTotal(diskToTalBytes).diskUsedPercentage((diskToTalBytes - diskFreeBytes) / diskToTalBytes).build();
        this.lastRefreshTime = System.currentTimeMillis();
        return this.systemMetrics;
    }

    private double calculateTotalMemory(MeterRegistry meterRegistry, String area, String name) {
        double memory = 0.0;
        Collection meters = meterRegistry.find(name).meters();
        for (Meter meter : meters) {
            double value;
            if (!area.equals(meter.getId().getTag("area")) || !((value = ((Measurement)meter.measure().iterator().next()).getValue()) > 0.0)) continue;
            memory += value;
        }
        return memory;
    }
}

