/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.SceneChangeInfo;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConcatDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        ConcatDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("Concat");
        request.getInput().setObject("demo.mp4");
        MediaConcatTemplateObject mediaConcatTemplate = request.getOperation().getMediaConcatTemplate();
        SceneChangeInfo sceneChangeInfo = mediaConcatTemplate.getSceneChangeInfo();
        sceneChangeInfo.setMode("XFADE");
        sceneChangeInfo.setTime("5");
        sceneChangeInfo.setTransitionType("fade");
        List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
        MediaConcatFragmentObject mediaConcatFragmentObject = new MediaConcatFragmentObject();
        mediaConcatFragmentObject.setMode("Start");
        mediaConcatFragmentObject.setUrl("https://demo-1234567890.cos.ap-chongqing.myqcloud.com/media/1.mp4");
        concatFragmentList.add(mediaConcatFragmentObject);
        MediaAudioObject audio = mediaConcatTemplate.getAudio();
        audio.setCodec("mp3");
        MediaVideoObject video = mediaConcatTemplate.getVideo();
        video.setCodec("H.264");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        MediaContainerObject container = mediaConcatTemplate.getContainer();
        container.setFormat("mp4");
        mediaConcatTemplate.setIndex("1");
        request.getOperation().getOutput().setBucket("demo-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("concat.mp4");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("j0d9e19eef00211ee9b72713e624*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void cancelMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean response = client.cancelMediaJob(request);
        System.out.println(response);
    }
}

