/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.concurrent.ThreadLocalRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesAndConfigEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesAndConfigEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
public class ConfigReloadAutoConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"})
    @ConditionalOnClass(value={RestartEndpoint.class, ContextRefresher.class})
    protected static class ConfigReloadAutoConfigurationBeans {
        protected ConfigReloadAutoConfigurationBeans() {
        }

        @Bean(value={"springCloudKubernetesTaskScheduler"})
        @ConditionalOnMissingBean
        public TaskSchedulerWrapper taskScheduler() {
            ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
            threadPoolTaskScheduler.setThreadNamePrefix("spring-cloud-kubernetes-ThreadPoolTaskScheduler-");
            threadPoolTaskScheduler.setDaemon(true);
            return new TaskSchedulerWrapper((TaskScheduler)threadPoolTaskScheduler);
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx, @Autowired(required=false) RestartEndpoint restarter, ContextRefresher refresher) {
            switch (properties.getStrategy()) {
                case RESTART_CONTEXT: {
                    Assert.notNull((Object)restarter, (String)"Restart endpoint is not enabled");
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        restarter.restart();
                    });
                }
                case REFRESH: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((ContextRefresher)refresher).refresh());
                }
                case SHUTDOWN: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        ctx.close();
                    });
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + (Object)((Object)properties.getStrategy()));
        }

        private static void wait(ConfigReloadProperties properties) {
            long waitMillis = ThreadLocalRandom.current().nextLong(properties.getMaxWaitForRestart().toMillis());
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

