/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.MonitoringAppSpecification;
import com.amazonaws.services.sagemaker.model.MonitoringBaselineConfig;
import com.amazonaws.services.sagemaker.model.MonitoringInput;
import com.amazonaws.services.sagemaker.model.MonitoringOutputConfig;
import com.amazonaws.services.sagemaker.model.MonitoringResources;
import com.amazonaws.services.sagemaker.model.MonitoringStoppingCondition;
import com.amazonaws.services.sagemaker.model.NetworkConfig;
import com.amazonaws.services.sagemaker.model.transform.MonitoringJobDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitoringJobDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private MonitoringBaselineConfig baselineConfig;
    private List<MonitoringInput> monitoringInputs;
    private MonitoringOutputConfig monitoringOutputConfig;
    private MonitoringResources monitoringResources;
    private MonitoringAppSpecification monitoringAppSpecification;
    private MonitoringStoppingCondition stoppingCondition;
    private Map<String, String> environment;
    private NetworkConfig networkConfig;
    private String roleArn;

    public void setBaselineConfig(MonitoringBaselineConfig baselineConfig) {
        this.baselineConfig = baselineConfig;
    }

    public MonitoringBaselineConfig getBaselineConfig() {
        return this.baselineConfig;
    }

    public MonitoringJobDefinition withBaselineConfig(MonitoringBaselineConfig baselineConfig) {
        this.setBaselineConfig(baselineConfig);
        return this;
    }

    public List<MonitoringInput> getMonitoringInputs() {
        return this.monitoringInputs;
    }

    public void setMonitoringInputs(Collection<MonitoringInput> monitoringInputs) {
        if (monitoringInputs == null) {
            this.monitoringInputs = null;
            return;
        }
        this.monitoringInputs = new ArrayList<MonitoringInput>(monitoringInputs);
    }

    public MonitoringJobDefinition withMonitoringInputs(MonitoringInput ... monitoringInputs) {
        if (this.monitoringInputs == null) {
            this.setMonitoringInputs(new ArrayList<MonitoringInput>(monitoringInputs.length));
        }
        for (MonitoringInput ele : monitoringInputs) {
            this.monitoringInputs.add(ele);
        }
        return this;
    }

    public MonitoringJobDefinition withMonitoringInputs(Collection<MonitoringInput> monitoringInputs) {
        this.setMonitoringInputs(monitoringInputs);
        return this;
    }

    public void setMonitoringOutputConfig(MonitoringOutputConfig monitoringOutputConfig) {
        this.monitoringOutputConfig = monitoringOutputConfig;
    }

    public MonitoringOutputConfig getMonitoringOutputConfig() {
        return this.monitoringOutputConfig;
    }

    public MonitoringJobDefinition withMonitoringOutputConfig(MonitoringOutputConfig monitoringOutputConfig) {
        this.setMonitoringOutputConfig(monitoringOutputConfig);
        return this;
    }

    public void setMonitoringResources(MonitoringResources monitoringResources) {
        this.monitoringResources = monitoringResources;
    }

    public MonitoringResources getMonitoringResources() {
        return this.monitoringResources;
    }

    public MonitoringJobDefinition withMonitoringResources(MonitoringResources monitoringResources) {
        this.setMonitoringResources(monitoringResources);
        return this;
    }

    public void setMonitoringAppSpecification(MonitoringAppSpecification monitoringAppSpecification) {
        this.monitoringAppSpecification = monitoringAppSpecification;
    }

    public MonitoringAppSpecification getMonitoringAppSpecification() {
        return this.monitoringAppSpecification;
    }

    public MonitoringJobDefinition withMonitoringAppSpecification(MonitoringAppSpecification monitoringAppSpecification) {
        this.setMonitoringAppSpecification(monitoringAppSpecification);
        return this;
    }

    public void setStoppingCondition(MonitoringStoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public MonitoringStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public MonitoringJobDefinition withStoppingCondition(MonitoringStoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public MonitoringJobDefinition withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public MonitoringJobDefinition addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public MonitoringJobDefinition clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public MonitoringJobDefinition withNetworkConfig(NetworkConfig networkConfig) {
        this.setNetworkConfig(networkConfig);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public MonitoringJobDefinition withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaselineConfig() != null) {
            sb.append("BaselineConfig: ").append(this.getBaselineConfig()).append(",");
        }
        if (this.getMonitoringInputs() != null) {
            sb.append("MonitoringInputs: ").append(this.getMonitoringInputs()).append(",");
        }
        if (this.getMonitoringOutputConfig() != null) {
            sb.append("MonitoringOutputConfig: ").append(this.getMonitoringOutputConfig()).append(",");
        }
        if (this.getMonitoringResources() != null) {
            sb.append("MonitoringResources: ").append(this.getMonitoringResources()).append(",");
        }
        if (this.getMonitoringAppSpecification() != null) {
            sb.append("MonitoringAppSpecification: ").append(this.getMonitoringAppSpecification()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getNetworkConfig() != null) {
            sb.append("NetworkConfig: ").append(this.getNetworkConfig()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringJobDefinition)) {
            return false;
        }
        MonitoringJobDefinition other = (MonitoringJobDefinition)obj;
        if (other.getBaselineConfig() == null ^ this.getBaselineConfig() == null) {
            return false;
        }
        if (other.getBaselineConfig() != null && !other.getBaselineConfig().equals(this.getBaselineConfig())) {
            return false;
        }
        if (other.getMonitoringInputs() == null ^ this.getMonitoringInputs() == null) {
            return false;
        }
        if (other.getMonitoringInputs() != null && !other.getMonitoringInputs().equals(this.getMonitoringInputs())) {
            return false;
        }
        if (other.getMonitoringOutputConfig() == null ^ this.getMonitoringOutputConfig() == null) {
            return false;
        }
        if (other.getMonitoringOutputConfig() != null && !other.getMonitoringOutputConfig().equals(this.getMonitoringOutputConfig())) {
            return false;
        }
        if (other.getMonitoringResources() == null ^ this.getMonitoringResources() == null) {
            return false;
        }
        if (other.getMonitoringResources() != null && !other.getMonitoringResources().equals(this.getMonitoringResources())) {
            return false;
        }
        if (other.getMonitoringAppSpecification() == null ^ this.getMonitoringAppSpecification() == null) {
            return false;
        }
        if (other.getMonitoringAppSpecification() != null && !other.getMonitoringAppSpecification().equals(this.getMonitoringAppSpecification())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getNetworkConfig() == null ^ this.getNetworkConfig() == null) {
            return false;
        }
        if (other.getNetworkConfig() != null && !other.getNetworkConfig().equals(this.getNetworkConfig())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaselineConfig() == null ? 0 : this.getBaselineConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringInputs() == null ? 0 : this.getMonitoringInputs().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringOutputConfig() == null ? 0 : this.getMonitoringOutputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringResources() == null ? 0 : this.getMonitoringResources().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringAppSpecification() == null ? 0 : this.getMonitoringAppSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfig() == null ? 0 : this.getNetworkConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public MonitoringJobDefinition clone() {
        try {
            return (MonitoringJobDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MonitoringJobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

