/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPGetAction;
import io.kubernetes.client.openapi.models.V1HTTPGetActionFluent;
import io.kubernetes.client.openapi.models.V1HTTPHeader;
import io.kubernetes.client.openapi.models.V1HTTPHeaderBuilder;
import io.kubernetes.client.openapi.models.V1HTTPHeaderFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HTTPGetActionFluentImpl<A extends V1HTTPGetActionFluent<A>>
extends BaseFluent<A>
implements V1HTTPGetActionFluent<A> {
    private String host;
    private List<V1HTTPHeaderBuilder> httpHeaders;
    private String path;
    private IntOrString port;
    private String scheme;

    public V1HTTPGetActionFluentImpl() {
    }

    public V1HTTPGetActionFluentImpl(V1HTTPGetAction instance) {
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public A withNewHost(String original) {
        return this.withHost(new String(original));
    }

    @Override
    public A addToHttpHeaders(int index, V1HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeaderBuilder>();
        }
        V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
        this._visitables.get("httpHeaders").add(index >= 0 ? index : this._visitables.get("httpHeaders").size(), builder);
        this.httpHeaders.add(index >= 0 ? index : this.httpHeaders.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttpHeaders(int index, V1HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeaderBuilder>();
        }
        V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
        if (index < 0 || index >= this._visitables.get("httpHeaders").size()) {
            this._visitables.get("httpHeaders").add(builder);
        } else {
            this._visitables.get("httpHeaders").set(index, builder);
        }
        if (index < 0 || index >= this.httpHeaders.size()) {
            this.httpHeaders.add(builder);
        } else {
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpHeaders(V1HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeaderBuilder>();
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpHeaders(Collection<V1HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeaderBuilder>();
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpHeaders(V1HTTPHeader ... items) {
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpHeaders(Collection<V1HTTPHeader> items) {
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpHeaders(Predicate<V1HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<V1HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        Object visitables = this._visitables.get("httpHeaders");
        while (each.hasNext()) {
            V1HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1HTTPHeader> getHttpHeaders() {
        return V1HTTPGetActionFluentImpl.build(this.httpHeaders);
    }

    @Override
    public List<V1HTTPHeader> buildHttpHeaders() {
        return V1HTTPGetActionFluentImpl.build(this.httpHeaders);
    }

    @Override
    public V1HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    @Override
    public V1HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    @Override
    public V1HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    @Override
    public V1HTTPHeader buildMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        for (V1HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        for (V1HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpHeaders(List<V1HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get("httpHeaders").removeAll(this.httpHeaders);
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList<V1HTTPHeaderBuilder>();
            for (V1HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpHeaders(V1HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
        }
        if (httpHeaders != null) {
            for (V1HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNestedImpl();
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(V1HTTPHeader item) {
        return new HttpHeadersNestedImpl(-1, item);
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(int index, V1HTTPHeader item) {
        return new HttpHeadersNestedImpl(index, item);
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String original) {
        return this.withPath(new String(original));
    }

    @Override
    public IntOrString getPort() {
        return this.port;
    }

    @Override
    public A withPort(IntOrString port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(int value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public A withNewPort(String value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    @Deprecated
    public A withNewScheme(String original) {
        return this.withScheme(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPGetActionFluentImpl that = (V1HTTPGetActionFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.httpHeaders != null ? !this.httpHeaders.equals(that.httpHeaders) : that.httpHeaders != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals((Object)that.port) : that.port != null) {
            return false;
        }
        return !(this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, super.hashCode());
    }

    public class HttpHeadersNestedImpl<N>
    extends V1HTTPHeaderFluentImpl<V1HTTPGetActionFluent.HttpHeadersNested<N>>
    implements V1HTTPGetActionFluent.HttpHeadersNested<N>,
    Nested<N> {
        private final V1HTTPHeaderBuilder builder;
        private final int index;

        HttpHeadersNestedImpl(int index, V1HTTPHeader item) {
            this.index = index;
            this.builder = new V1HTTPHeaderBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.index = -1;
            this.builder = new V1HTTPHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HTTPGetActionFluentImpl.this.setToHttpHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHttpHeader() {
            return this.and();
        }
    }
}

