/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.cdn.fluent.models.EndpointInner;
import com.azure.resourcemanager.cdn.models.CdnProfile;
import com.azure.resourcemanager.cdn.models.CustomDomainValidationResult;
import com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.GeoFilterActions;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.azure.resourcemanager.resources.fluentcore.arm.CountryIsoCode;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.util.Collection;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface CdnEndpoint
extends ExternalChildResource<CdnEndpoint, CdnProfile>,
HasInnerModel<EndpointInner> {
    public String originHostHeader();

    public String originPath();

    public Set<String> contentTypesToCompress();

    public boolean isCompressionEnabled();

    public boolean isHttpAllowed();

    public boolean isHttpsAllowed();

    public QueryStringCachingBehavior queryStringCachingBehavior();

    public String optimizationType();

    public Collection<GeoFilter> geoFilters();

    public String hostname();

    public EndpointResourceState resourceState();

    public String provisioningState();

    public String originHostName();

    public int httpPort();

    public int httpsPort();

    public Set<String> customDomains();

    public void start();

    public Mono<Void> startAsync();

    public void stop();

    public Mono<Void> stopAsync();

    public void purgeContent(Set<String> var1);

    public Mono<Void> purgeContentAsync(Set<String> var1);

    public void loadContent(Set<String> var1);

    public Mono<Void> loadContentAsync(Set<String> var1);

    public CustomDomainValidationResult validateCustomDomain(String var1);

    public Mono<CustomDomainValidationResult> validateCustomDomainAsync(String var1);

    public PagedIterable<ResourceUsage> listResourceUsage();

    public static interface Update
    extends Settable<CdnProfile.Update> {
    }

    public static interface UpdatePremiumEndpoint
    extends Update {
        public UpdatePremiumEndpoint withOriginPath(String var1);

        public UpdatePremiumEndpoint withHostHeader(String var1);

        public UpdatePremiumEndpoint withHttpAllowed(boolean var1);

        public UpdatePremiumEndpoint withHttpsAllowed(boolean var1);

        public UpdatePremiumEndpoint withHttpPort(int var1);

        public UpdatePremiumEndpoint withHttpsPort(int var1);

        public UpdatePremiumEndpoint withCustomDomain(String var1);

        public UpdatePremiumEndpoint withoutCustomDomain(String var1);
    }

    public static interface UpdateStandardEndpoint
    extends Update {
        public UpdateStandardEndpoint withOriginPath(String var1);

        public UpdateStandardEndpoint withHostHeader(String var1);

        public UpdateStandardEndpoint withHttpAllowed(boolean var1);

        public UpdateStandardEndpoint withHttpsAllowed(boolean var1);

        public UpdateStandardEndpoint withHttpPort(int var1);

        public UpdateStandardEndpoint withHttpsPort(int var1);

        public UpdateStandardEndpoint withContentTypesToCompress(Set<String> var1);

        public UpdateStandardEndpoint withoutContentTypesToCompress();

        public UpdateStandardEndpoint withContentTypeToCompress(String var1);

        public UpdateStandardEndpoint withoutContentTypeToCompress(String var1);

        public UpdateStandardEndpoint withCompressionEnabled(boolean var1);

        public UpdateStandardEndpoint withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

        public UpdateStandardEndpoint withGeoFilters(Collection<GeoFilter> var1);

        public UpdateStandardEndpoint withoutGeoFilters();

        public UpdateStandardEndpoint withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

        public UpdateStandardEndpoint withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

        public UpdateStandardEndpoint withoutGeoFilter(String var1);

        public UpdateStandardEndpoint withCustomDomain(String var1);

        public UpdateStandardEndpoint withoutCustomDomain(String var1);
    }

    public static interface UpdateDefinitionStages {

        public static interface AttachablePremium<ParentT> {
            public ParentT attach();
        }

        public static interface AttachableStandard<ParentT> {
            public ParentT attach();
        }

        public static interface WithPremiumAttach<ParentT>
        extends AttachablePremium<ParentT> {
            public WithPremiumAttach<ParentT> withOriginPath(String var1);

            public WithPremiumAttach<ParentT> withHostHeader(String var1);

            public WithPremiumAttach<ParentT> withHttpAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpPort(int var1);

            public WithPremiumAttach<ParentT> withHttpsPort(int var1);

            public WithPremiumAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface WithStandardAttach<ParentT>
        extends AttachableStandard<ParentT> {
            public WithStandardAttach<ParentT> withOriginPath(String var1);

            public WithStandardAttach<ParentT> withHostHeader(String var1);

            public WithStandardAttach<ParentT> withHttpAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpPort(int var1);

            public WithStandardAttach<ParentT> withHttpsPort(int var1);

            public WithStandardAttach<ParentT> withContentTypesToCompress(Set<String> var1);

            public WithStandardAttach<ParentT> withContentTypeToCompress(String var1);

            public WithStandardAttach<ParentT> withCompressionEnabled(boolean var1);

            public WithStandardAttach<ParentT> withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

            public WithStandardAttach<ParentT> withGeoFilters(Collection<GeoFilter> var1);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

            public WithStandardAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface Blank {

            public static interface PremiumEndpoint<ParentT> {
                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1, String var2);

                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1);
            }

            public static interface StandardEndpoint<ParentT> {
                public WithStandardAttach<ParentT> withOrigin(String var1, String var2);

                public WithStandardAttach<ParentT> withOrigin(String var1);
            }
        }
    }

    public static interface DefinitionStages {

        public static interface AttachablePremium<ParentT> {
            public ParentT attach();
        }

        public static interface AttachableStandard<ParentT> {
            public ParentT attach();
        }

        public static interface WithPremiumAttach<ParentT>
        extends AttachablePremium<ParentT> {
            public WithPremiumAttach<ParentT> withOriginPath(String var1);

            public WithPremiumAttach<ParentT> withHostHeader(String var1);

            public WithPremiumAttach<ParentT> withHttpAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpPort(int var1);

            public WithPremiumAttach<ParentT> withHttpsPort(int var1);

            public WithPremiumAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface WithStandardAttach<ParentT>
        extends AttachableStandard<ParentT> {
            public WithStandardAttach<ParentT> withOriginPath(String var1);

            public WithStandardAttach<ParentT> withHostHeader(String var1);

            public WithStandardAttach<ParentT> withHttpAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpPort(int var1);

            public WithStandardAttach<ParentT> withHttpsPort(int var1);

            public WithStandardAttach<ParentT> withContentTypesToCompress(Set<String> var1);

            public WithStandardAttach<ParentT> withContentTypeToCompress(String var1);

            public WithStandardAttach<ParentT> withCompressionEnabled(boolean var1);

            public WithStandardAttach<ParentT> withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

            public WithStandardAttach<ParentT> withGeoFilters(Collection<GeoFilter> var1);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

            public WithStandardAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface Blank {

            public static interface PremiumEndpoint<ParentT> {
                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1, String var2);

                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1);
            }

            public static interface StandardEndpoint<ParentT> {
                public WithStandardAttach<ParentT> withOrigin(String var1, String var2);

                public WithStandardAttach<ParentT> withOrigin(String var1);
            }
        }
    }
}

