/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.config;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.common.config.IPropertyDelegate;
import org.apache.dolphinscheduler.common.config.ImmutablePropertyDelegate;
import org.apache.dolphinscheduler.common.config.ImmutableYamlDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutablePriorityPropertyDelegate
implements IPropertyDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImmutablePriorityPropertyDelegate.class);
    private static final Map<String, Optional<ConfigValue<String>>> configValueMap = new ConcurrentHashMap<String, Optional<ConfigValue<String>>>();
    private ImmutablePropertyDelegate immutablePropertyDelegate;
    private ImmutableYamlDelegate immutableYamlDelegate;

    public ImmutablePriorityPropertyDelegate(ImmutablePropertyDelegate immutablePropertyDelegate, ImmutableYamlDelegate immutableYamlDelegate) {
        this.immutablePropertyDelegate = immutablePropertyDelegate;
        this.immutableYamlDelegate = immutableYamlDelegate;
    }

    @Override
    public String get(String key) {
        Optional configValue = configValueMap.computeIfAbsent(key, k -> {
            Optional<ConfigValue<String>> value = this.getConfigValueFromEnv(key);
            if (value.isPresent()) {
                log.debug("Override config value from env, key: {} actualKey: {}, value: {}", new Object[]{k, value.get().getActualKey(), value.get().getValue()});
                return value;
            }
            value = this.getConfigValueFromJvm(key);
            if (value.isPresent()) {
                log.debug("Override config value from jvm, key: {} actualKey: {}, value: {}", new Object[]{k, value.get().getActualKey(), value.get().getValue()});
                return value;
            }
            value = this.getConfigValueFromProperties(key);
            if (value.isPresent()) {
                log.debug("Get config value from properties, key: {} actualKey: {}, value: {}", new Object[]{k, value.get().getActualKey(), value.get().getValue()});
                return value;
            }
            value = this.getConfigValueFromYaml(key);
            value.ifPresent(stringConfigValue -> log.debug("Get config value from yaml, key: {} actualKey: {}, value: {}", new Object[]{k, stringConfigValue.getActualKey(), stringConfigValue.getValue()}));
            return value;
        });
        return configValue.map(ConfigValue::getValue).orElse(null);
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Set<String> getPropertyKeys() {
        HashSet<String> propertyKeys = new HashSet<String>();
        propertyKeys.addAll(this.immutablePropertyDelegate.getPropertyKeys());
        propertyKeys.addAll(this.immutableYamlDelegate.getPropertyKeys());
        propertyKeys.addAll(System.getProperties().stringPropertyNames());
        propertyKeys.addAll(System.getenv().keySet());
        return propertyKeys;
    }

    private Optional<ConfigValue<String>> getConfigValueFromEnv(String key) {
        String value = System.getenv(key);
        if (value != null) {
            return Optional.of(ConfigValue.fromEnv(key, value));
        }
        String envVarKey = String.valueOf(key).replaceAll("[.-]", "_").toUpperCase();
        String envVarVal = System.getenv(envVarKey);
        if (envVarVal != null) {
            return Optional.of(ConfigValue.fromEnv(key, envVarVal));
        }
        return Optional.empty();
    }

    private Optional<ConfigValue<String>> getConfigValueFromJvm(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return Optional.of(ConfigValue.fromJvm(key, value));
        }
        return Optional.empty();
    }

    private Optional<ConfigValue<String>> getConfigValueFromProperties(String key) {
        String value = this.immutablePropertyDelegate.get(key);
        if (value != null) {
            return Optional.of(ConfigValue.fromProperties(key, value));
        }
        return Optional.empty();
    }

    private Optional<ConfigValue<String>> getConfigValueFromYaml(String key) {
        String value = this.immutableYamlDelegate.get(key);
        if (value != null) {
            return Optional.of(ConfigValue.fromProperties(key, value));
        }
        return Optional.empty();
    }

    public static final class ConfigValue<T> {
        private String actualKey;
        private T value;
        private boolean fromProperties;
        private boolean fromJvm;
        private boolean fromEnv;

        public static <T> ConfigValue<T> fromProperties(String actualKey, T value) {
            return new ConfigValue<T>(actualKey, value, true, false, false);
        }

        public static <T> ConfigValue<T> fromJvm(String actualKey, T value) {
            return new ConfigValue<T>(actualKey, value, false, true, false);
        }

        public static <T> ConfigValue<T> fromEnv(String actualKey, T value) {
            return new ConfigValue<T>(actualKey, value, false, false, true);
        }

        @Generated
        public String getActualKey() {
            return this.actualKey;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public boolean isFromProperties() {
            return this.fromProperties;
        }

        @Generated
        public boolean isFromJvm() {
            return this.fromJvm;
        }

        @Generated
        public boolean isFromEnv() {
            return this.fromEnv;
        }

        @Generated
        public void setActualKey(String actualKey) {
            this.actualKey = actualKey;
        }

        @Generated
        public void setValue(T value) {
            this.value = value;
        }

        @Generated
        public void setFromProperties(boolean fromProperties) {
            this.fromProperties = fromProperties;
        }

        @Generated
        public void setFromJvm(boolean fromJvm) {
            this.fromJvm = fromJvm;
        }

        @Generated
        public void setFromEnv(boolean fromEnv) {
            this.fromEnv = fromEnv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigValue)) {
                return false;
            }
            ConfigValue other = (ConfigValue)o;
            if (this.isFromProperties() != other.isFromProperties()) {
                return false;
            }
            if (this.isFromJvm() != other.isFromJvm()) {
                return false;
            }
            if (this.isFromEnv() != other.isFromEnv()) {
                return false;
            }
            String this$actualKey = this.getActualKey();
            String other$actualKey = other.getActualKey();
            if (this$actualKey == null ? other$actualKey != null : !this$actualKey.equals(other$actualKey)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFromProperties() ? 79 : 97);
            result = result * 59 + (this.isFromJvm() ? 79 : 97);
            result = result * 59 + (this.isFromEnv() ? 79 : 97);
            String $actualKey = this.getActualKey();
            result = result * 59 + ($actualKey == null ? 43 : $actualKey.hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ImmutablePriorityPropertyDelegate.ConfigValue(actualKey=" + this.getActualKey() + ", value=" + this.getValue() + ", fromProperties=" + this.isFromProperties() + ", fromJvm=" + this.isFromJvm() + ", fromEnv=" + this.isFromEnv() + ")";
        }

        @Generated
        public ConfigValue(String actualKey, T value, boolean fromProperties, boolean fromJvm, boolean fromEnv) {
            this.actualKey = actualKey;
            this.value = value;
            this.fromProperties = fromProperties;
            this.fromJvm = fromJvm;
            this.fromEnv = fromEnv;
        }
    }
}

