/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.GlobalParametersClient;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;
import com.azure.resourcemanager.datafactory.implementation.GlobalParameterResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.GlobalParameterResource;
import com.azure.resourcemanager.datafactory.models.GlobalParameters;

public final class GlobalParametersImpl
implements GlobalParameters {
    private static final ClientLogger LOGGER = new ClientLogger(GlobalParametersImpl.class);
    private final GlobalParametersClient innerClient;
    private final DataFactoryManager serviceManager;

    public GlobalParametersImpl(GlobalParametersClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GlobalParameterResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<GlobalParameterResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return Utils.mapPage(inner, inner1 -> new GlobalParameterResourceImpl((GlobalParameterResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GlobalParameterResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<GlobalParameterResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return Utils.mapPage(inner, inner1 -> new GlobalParameterResourceImpl((GlobalParameterResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GlobalParameterResource> getWithResponse(String resourceGroupName, String factoryName, String globalParameterName, Context context) {
        Response<GlobalParameterResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, globalParameterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GlobalParameterResourceImpl((GlobalParameterResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GlobalParameterResource get(String resourceGroupName, String factoryName, String globalParameterName) {
        GlobalParameterResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, globalParameterName);
        if (inner != null) {
            return new GlobalParameterResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String globalParameterName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, globalParameterName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String globalParameterName) {
        this.serviceClient().delete(resourceGroupName, factoryName, globalParameterName);
    }

    @Override
    public GlobalParameterResource getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String globalParameterName = Utils.getValueFromIdByName(id, "globalParameters");
        if (globalParameterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'globalParameters'.", id)));
        }
        return (GlobalParameterResource)this.getWithResponse(resourceGroupName, factoryName, globalParameterName, Context.NONE).getValue();
    }

    @Override
    public Response<GlobalParameterResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String globalParameterName = Utils.getValueFromIdByName(id, "globalParameters");
        if (globalParameterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'globalParameters'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, globalParameterName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String globalParameterName = Utils.getValueFromIdByName(id, "globalParameters");
        if (globalParameterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'globalParameters'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, globalParameterName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String globalParameterName = Utils.getValueFromIdByName(id, "globalParameters");
        if (globalParameterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'globalParameters'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, globalParameterName, context);
    }

    private GlobalParametersClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public GlobalParameterResourceImpl define(String name) {
        return new GlobalParameterResourceImpl(name, this.manager());
    }
}

