/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.ScriptActivityParameter;
import com.azure.resourcemanager.datafactory.models.ScriptType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ScriptActivityScriptBlock {
    @JsonProperty(value="text", required=true)
    private Object text;
    @JsonProperty(value="type", required=true)
    private ScriptType type;
    @JsonProperty(value="parameters")
    private List<ScriptActivityParameter> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivityScriptBlock.class);

    public Object text() {
        return this.text;
    }

    public ScriptActivityScriptBlock withText(Object text) {
        this.text = text;
        return this;
    }

    public ScriptType type() {
        return this.type;
    }

    public ScriptActivityScriptBlock withType(ScriptType type) {
        this.type = type;
        return this;
    }

    public List<ScriptActivityParameter> parameters() {
        return this.parameters;
    }

    public ScriptActivityScriptBlock withParameters(List<ScriptActivityParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.text() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property text in model ScriptActivityScriptBlock"));
        }
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ScriptActivityScriptBlock"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }
}

