/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.UsageInner;
import com.azure.resourcemanager.compute.implementation.ComputeUsageImpl;
import com.azure.resourcemanager.compute.models.ComputeUsage;
import com.azure.resourcemanager.compute.models.ComputeUsages;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;

public class ComputeUsagesImpl
extends ReadableWrappersImpl<ComputeUsage, ComputeUsageImpl, UsageInner>
implements ComputeUsages {
    private final ComputeManagementClient client;

    public ComputeUsagesImpl(ComputeManagementClient client) {
        this.client = client;
    }

    public PagedIterable<ComputeUsage> listByRegion(Region region) {
        return this.listByRegion(region.name());
    }

    public PagedIterable<ComputeUsage> listByRegion(String regionName) {
        return this.wrapList(this.client.getUsages().list(regionName));
    }

    public PagedFlux<ComputeUsage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public PagedFlux<ComputeUsage> listByRegionAsync(String regionName) {
        return this.wrapPageAsync(this.client.getUsages().listAsync(regionName));
    }

    protected ComputeUsageImpl wrapModel(UsageInner usageInner) {
        if (usageInner == null) {
            return null;
        }
        return new ComputeUsageImpl(usageInner);
    }
}

