/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.kubernetes.client.openapi.ApiClient;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.k8s.discovery.DefaultK8sLeaderElectorFactory;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sDruidLeaderSelector;
import org.apache.druid.k8s.discovery.PodInfo;
import org.apache.druid.server.DruidNode;

public abstract class K8sDruidLeaderSelectorProvider
implements Provider<DruidLeaderSelector> {
    @Inject
    @Self
    private DruidNode druidNode;
    @Inject
    private PodInfo podInfo;
    @Inject
    private K8sDiscoveryConfig discoveryConfig;
    @Inject
    private Provider<ApiClient> k8sApiClientProvider;
    private boolean isCoordinator;

    K8sDruidLeaderSelectorProvider(boolean isCoordinator) {
        this.isCoordinator = isCoordinator;
    }

    public DruidLeaderSelector get() {
        String lockResourceNamespace;
        String lockResourceName;
        if (this.isCoordinator) {
            lockResourceName = this.discoveryConfig.getClusterIdentifier() + "-leaderelection-coordinator";
            lockResourceNamespace = this.discoveryConfig.getCoordinatorLeaderElectionConfigMapNamespace() == null ? this.podInfo.getPodNamespace() : this.discoveryConfig.getCoordinatorLeaderElectionConfigMapNamespace();
        } else {
            lockResourceName = this.discoveryConfig.getClusterIdentifier() + "-leaderelection-overlord";
            lockResourceNamespace = this.discoveryConfig.getOverlordLeaderElectionConfigMapNamespace() == null ? this.podInfo.getPodNamespace() : this.discoveryConfig.getOverlordLeaderElectionConfigMapNamespace();
        }
        return new K8sDruidLeaderSelector(this.druidNode, lockResourceName, lockResourceNamespace, this.discoveryConfig, new DefaultK8sLeaderElectorFactory((ApiClient)this.k8sApiClientProvider.get(), this.discoveryConfig));
    }

    static class K8sIndexingServiceDruidLeaderSelectorProvider
    extends K8sDruidLeaderSelectorProvider {
        @Inject
        public K8sIndexingServiceDruidLeaderSelectorProvider() {
            super(false);
        }
    }

    static class K8sCoordinatorDruidLeaderSelectorProvider
    extends K8sDruidLeaderSelectorProvider {
        @Inject
        public K8sCoordinatorDruidLeaderSelectorProvider() {
            super(true);
        }
    }
}

