/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.java.util.common.IAE;

public class ColumnSpec {
    private final String name;
    private final String dataType;
    private final Map<String, Object> properties;

    @JsonCreator
    public ColumnSpec(@JsonProperty(value="name") String name, @JsonProperty(value="dataType") @Nullable String dataType, @JsonProperty(value="properties") @Nullable Map<String, Object> properties) {
        this.name = name;
        this.dataType = dataType;
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    public ColumnSpec(ColumnSpec from) {
        this(from.name, from.dataType, from.properties);
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String dataType() {
        return this.dataType;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> properties() {
        return this.properties;
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            throw new IAE("Column name is required", new Object[0]);
        }
        if (Columns.isTimeColumn(this.name) && this.dataType != null && !Columns.LONG.equalsIgnoreCase(this.dataType)) {
            throw new IAE("[%s] column must have type [%s] or no type. Found [%s]", new Object[]{this.name, Columns.LONG, this.dataType});
        }
    }

    public ColumnSpec merge(Map<String, ModelProperties.PropertyDefn<?>> columnProperties, ColumnSpec update) {
        String revisedType = update.dataType() == null ? this.dataType() : update.dataType();
        Map<String, Object> revisedProps = CatalogUtils.mergeProperties(columnProperties, this.properties(), update.properties());
        return new ColumnSpec(this.name(), revisedType, revisedProps);
    }

    public String toString() {
        return CatalogUtils.toString(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ColumnSpec other = (ColumnSpec)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.properties);
    }
}

