/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ObjectDefn;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.java.util.common.IAE;

public class TableDefn
extends ObjectDefn {
    public static final String DESCRIPTION_PROPERTY = "description";
    private final Map<String, ModelProperties.PropertyDefn<?>> columnProperties;

    public TableDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> properties, List<ModelProperties.PropertyDefn<?>> columnProperties) {
        super(name, typeValue, CatalogUtils.concatLists(Collections.singletonList(new ModelProperties.StringPropertyDefn(DESCRIPTION_PROPERTY)), properties));
        this.columnProperties = TableDefn.toPropertyMap(columnProperties);
    }

    public void bind(TableDefnRegistry registry) {
    }

    public void validate(ResolvedTable table) {
        this.validate(table.properties(), table.jsonMapper());
        this.validateColumns(table.spec().columns());
    }

    public void validateColumns(List<ColumnSpec> columns) {
        if (columns == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (ColumnSpec colSpec : columns) {
            if (!names.add(colSpec.name())) {
                throw new IAE("Duplicate column name: " + colSpec.name(), new Object[0]);
            }
            colSpec.validate();
            this.validateColumn(colSpec);
        }
    }

    protected void validateColumn(ColumnSpec colSpec) {
    }

    public TableSpec merge(TableSpec spec, TableSpec update, ObjectMapper jsonMapper) {
        String updateType = update.type();
        if (updateType != null && !spec.type().equals(updateType)) {
            throw new IAE("The update type must be null or [%s]", new Object[]{spec.type()});
        }
        Map<String, Object> revisedProps = this.mergeProperties(spec.properties(), update.properties());
        List<ColumnSpec> revisedColumns = this.mergeColumns(spec.columns(), update.columns());
        TableSpec revisedSpec = new TableSpec(spec.type(), revisedProps, revisedColumns);
        this.validate(new ResolvedTable(this, revisedSpec, jsonMapper));
        return revisedSpec;
    }

    public List<ColumnSpec> mergeColumns(List<ColumnSpec> columns, List<ColumnSpec> update) {
        if (update == null || update.isEmpty()) {
            return columns;
        }
        HashMap<String, Integer> original = new HashMap<String, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            original.put(columns.get(i).name(), i);
        }
        ArrayList<ColumnSpec> merged = new ArrayList<ColumnSpec>(columns);
        for (int i = 0; i < update.size(); ++i) {
            ColumnSpec col = update.get(i);
            String colName = col.name();
            if (Strings.isNullOrEmpty((String)colName)) {
                throw new IAE("Column %d must have a name", new Object[]{i + 1});
            }
            Integer index = (Integer)original.get(col.name());
            if (index == null) {
                merged.add(col);
                continue;
            }
            merged.set(index, this.mergeColumn(columns.get(index), col));
        }
        return merged;
    }

    private ColumnSpec mergeColumn(ColumnSpec existingCol, ColumnSpec update) {
        ColumnSpec revised = existingCol.merge(this.columnProperties, update);
        revised.validate();
        this.validateColumn(revised);
        return revised;
    }
}

