/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import com.google.common.base.Supplier;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.metadata.segment.cache.DatasourceSegmentCache;

public abstract class ReadWriteCache
implements DatasourceSegmentCache {
    private final ReentrantReadWriteLock stateLock;
    private volatile boolean isStopped = false;

    public ReadWriteCache(boolean fair) {
        this.stateLock = new ReentrantReadWriteLock(fair);
    }

    public void stop() {
        this.withWriteLock(() -> {
            this.isStopped = true;
        });
    }

    public void withWriteLock(Action action) {
        this.withWriteLock(() -> {
            action.perform();
            return 0;
        });
    }

    public <T> T withWriteLock(Supplier<T> action) {
        this.stateLock.writeLock().lock();
        try {
            this.verifyCacheIsNotStopped();
            Object object = action.get();
            return (T)object;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public <T> T withReadLock(Supplier<T> action) {
        this.stateLock.readLock().lock();
        try {
            this.verifyCacheIsNotStopped();
            Object object = action.get();
            return (T)object;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private void verifyCacheIsNotStopped() {
        if (this.isStopped) {
            throw InternalServerError.exception((String)"Cannot perform operation on cache as it is already stopped", (Object[])new Object[0]);
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void perform();
    }
}

