/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class KillStalePendingSegments
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillStalePendingSegments.class);
    private static final Period DURATION_TO_RETAIN = new Period((Object)"P1D");
    private final OverlordClient overlordClient;

    public KillStalePendingSegments(OverlordClient overlordClient) {
        this.overlordClient = overlordClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        HashSet<String> killDatasources = new HashSet<String>(params.getUsedSegmentsTimelinesPerDataSource().keySet());
        killDatasources.removeAll(params.getCoordinatorDynamicConfig().getDataSourcesToNotKillStalePendingSegmentsIn());
        DateTime minCreatedTime = this.getMinCreatedTimeToRetain();
        for (String dataSource : killDatasources) {
            int pendingSegmentsKilled = (Integer)FutureUtils.getUnchecked(this.overlordClient.killPendingSegments(dataSource, new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)minCreatedTime)), (boolean)true);
            if (pendingSegmentsKilled <= 0) continue;
            log.info("Killed [%d] pendingSegments created before [%s] for datasource[%s].", new Object[]{pendingSegmentsKilled, minCreatedTime, dataSource});
            params.getCoordinatorStats().add(Stats.Kill.PENDING_SEGMENTS, RowKey.of(Dimension.DATASOURCE, dataSource), pendingSegmentsKilled);
        }
        return params;
    }

    private DateTime getMinCreatedTimeToRetain() {
        ImmutableList statuses = ImmutableList.copyOf((Iterator)((Iterator)FutureUtils.getUnchecked(this.overlordClient.taskStatuses(null, null, 1), (boolean)true)));
        DateTime earliestActiveTaskStart = DateTimes.nowUtc();
        DateTime latestCompletedTaskStart = null;
        for (TaskStatusPlus status : statuses) {
            if (status.getStatusCode() != null && status.getStatusCode().isComplete()) {
                latestCompletedTaskStart = DateTimes.laterOf(latestCompletedTaskStart, (DateTime)status.getCreatedTime());
                continue;
            }
            earliestActiveTaskStart = DateTimes.earlierOf((DateTime)earliestActiveTaskStart, (DateTime)status.getCreatedTime());
        }
        return DateTimes.earlierOf(latestCompletedTaskStart, (DateTime)earliestActiveTaskStart).minus((ReadablePeriod)DURATION_TO_RETAIN);
    }
}

