/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.server.coordinator.loading.SegmentReplicaCount;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class SegmentReplicationStatus {
    private final Map<SegmentId, SegmentReplicaCount> totalReplicaCounts;
    private final Map<SegmentId, Map<String, SegmentReplicaCount>> replicaCountsInTier;

    public SegmentReplicationStatus(Map<SegmentId, Map<String, SegmentReplicaCount>> replicaCountsInTier) {
        this.replicaCountsInTier = ImmutableMap.copyOf(replicaCountsInTier);
        HashMap totalReplicaCounts = new HashMap();
        replicaCountsInTier.forEach((segmentId, tierToReplicaCount) -> {
            SegmentReplicaCount total = new SegmentReplicaCount();
            tierToReplicaCount.values().forEach(total::accumulate);
            totalReplicaCounts.put(segmentId, total);
        });
        this.totalReplicaCounts = ImmutableMap.copyOf(totalReplicaCounts);
    }

    public SegmentReplicaCount getReplicaCountsInCluster(SegmentId segmentId) {
        return this.totalReplicaCounts.get(segmentId);
    }

    public Map<String, Object2LongMap<String>> getTierToDatasourceToUnderReplicated(Iterable<DataSegment> usedSegments, boolean ignoreMissingServers) {
        HashMap<String, Object2LongMap<String>> tierToUnderReplicated = new HashMap<String, Object2LongMap<String>>();
        for (DataSegment segment : usedSegments) {
            Map<String, SegmentReplicaCount> tierToReplicaCount = this.replicaCountsInTier.get(segment.getId());
            if (tierToReplicaCount == null) continue;
            tierToReplicaCount.forEach((tier, counts) -> {
                int underReplicated;
                int n = underReplicated = ignoreMissingServers ? counts.missing() : counts.missingAndLoadable();
                if (underReplicated >= 0) {
                    Object2LongOpenHashMap datasourceToUnderReplicated = (Object2LongOpenHashMap)tierToUnderReplicated.computeIfAbsent((String)tier, ds -> new Object2LongOpenHashMap());
                    datasourceToUnderReplicated.addTo((Object)segment.getDataSource(), (long)underReplicated);
                }
            });
        }
        return tierToUnderReplicated;
    }
}

