/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.List;
import javax.ws.rs.core.PathSegment;
import org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

public class DatasourceResourceFilter
extends AbstractResourceFilter {
    private static final String DATASOURCES_PATH_SEGMENT = "datasources";

    @Inject
    public DatasourceResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource(this.getRequestDatasourceName(request), "DATASOURCE"), this.getAction(request));
        AuthorizationResult authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.allowAccessWithNoRestriction()) {
            throw new ForbiddenException(authResult.getErrorMessage());
        }
        return request;
    }

    private String getRequestDatasourceName(ContainerRequest request) {
        List pathSegments = request.getPathSegments();
        String dataSourceName = ((PathSegment)pathSegments.get(Iterables.indexOf((Iterable)pathSegments, input -> DATASOURCES_PATH_SEGMENT.equals(input.getPath())) + 1)).getPath();
        Preconditions.checkNotNull((Object)dataSourceName);
        return dataSourceName;
    }
}

