/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.google;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.google.GoogleCloudStorageEntity;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleUtils;

public class GoogleCloudStorageInputSource
extends CloudObjectInputSource {
    public static final String TYPE_KEY = "google";
    private static final Logger LOG = new Logger(GoogleCloudStorageInputSource.class);
    private final GoogleStorage storage;
    private final GoogleInputDataConfig inputDataConfig;

    @JsonCreator
    public GoogleCloudStorageInputSource(@JacksonInject GoogleStorage storage, @JacksonInject GoogleInputDataConfig inputDataConfig, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects, @JsonProperty(value="objectGlob") @Nullable String objectGlob, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields) {
        super("gs", uris, prefixes, objects, objectGlob, systemFields);
        this.storage = storage;
        this.inputDataConfig = inputDataConfig;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    protected InputEntity createEntity(CloudObjectLocation location) {
        return new GoogleCloudStorageEntity(this.storage, location);
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new GoogleCloudStorageInputSource(this.storage, this.inputDataConfig, null, null, (List)split.get(), this.getObjectGlob(), this.systemFields);
    }

    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        GoogleCloudStorageEntity googleEntity = (GoogleCloudStorageEntity)entity;
        switch (field) {
            case URI: {
                return googleEntity.getUri().toString();
            }
            case BUCKET: {
                return googleEntity.getLocation().getBucket();
            }
            case PATH: {
                return googleEntity.getLocation().getPath();
            }
        }
        return null;
    }

    protected CloudObjectSplitWidget getSplitWidget() {
        class SplitWidget
        implements CloudObjectSplitWidget {
            SplitWidget() {
            }

            public Iterator<CloudObjectSplitWidget.LocationWithSize> getDescriptorIteratorForPrefixes(List<URI> prefixes) {
                return Iterators.transform(GoogleUtils.lazyFetchingStorageObjectsIterator(GoogleCloudStorageInputSource.this.storage, prefixes.iterator(), GoogleCloudStorageInputSource.this.inputDataConfig.getMaxListingLength()), object -> new CloudObjectSplitWidget.LocationWithSize(object.getBucket(), object.getName(), GoogleCloudStorageInputSource.getSize(object)));
            }

            public long getObjectSize(CloudObjectLocation location) throws IOException {
                GoogleStorageObjectMetadata storageObject = GoogleCloudStorageInputSource.this.storage.getMetadata(location.getBucket(), location.getPath());
                return GoogleCloudStorageInputSource.getSize(storageObject);
            }
        }
        return new SplitWidget();
    }

    private static long getSize(GoogleStorageObjectMetadata object) {
        Long sizeInLong = object.getSize();
        if (sizeInLong == null) {
            return Long.MAX_VALUE;
        }
        try {
            return sizeInLong;
        }
        catch (ArithmeticException e) {
            LOG.warn((Throwable)e, "The object [%s, %s] has a size [%s] out of the range of the long type. The max long value will be used for its size instead.", new Object[]{object.getBucket(), object.getName(), sizeInLong});
            return Long.MAX_VALUE;
        }
    }

    public String toString() {
        return "GoogleCloudStorageInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + ", objectGlob=" + this.getObjectGlob() + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + this.systemFields) + "}";
    }
}

