/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.metrics;

import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.SegmentMetadataEvent;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class EventMapDeserializer {
    private static final Set<String> SYSTEM_DIMENSIONS = Set.of("feed", "timestamp", "service", "host", "metric", "value");
    private final EventMap map;

    EventMapDeserializer(EventMap map) {
        this.map = map;
    }

    Event asEvent() {
        String feed;
        switch (feed = this.getStringValue("feed")) {
            case "alerts": {
                return this.asAlertEvent();
            }
            case "segment_metadata": {
                return this.asSegmentMetadataEvent();
            }
        }
        return this.asMetricEvent();
    }

    String getService() {
        return this.getStringValue("service");
    }

    String getHost() {
        return this.getStringValue("host");
    }

    private String getStringValue(String key) {
        return (String)this.map.get((Object)key);
    }

    private AlertEvent asAlertEvent() {
        return new AlertEvent(DateTimes.of((String)this.getStringValue("timestamp")), this.getService(), this.getHost(), AlertEvent.Severity.fromString((String)this.getStringValue("severity")), this.getStringValue("description"), (Map)this.map.get((Object)"data"));
    }

    private ServiceMetricEvent asMetricEvent() {
        ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder();
        this.map.forEach((key, value) -> {
            if (!SYSTEM_DIMENSIONS.contains(key)) {
                builder.setDimension(key, this.map.get(key));
            }
        });
        return (ServiceMetricEvent)builder.setFeed(this.getStringValue("feed")).setCreatedTime(DateTimes.of((String)this.getStringValue("timestamp"))).setMetric(this.getStringValue("metric"), (Number)this.map.get((Object)"value")).build(this.getService(), this.getHost());
    }

    private SegmentMetadataEvent asSegmentMetadataEvent() {
        return new SegmentMetadataEvent(this.getStringValue("dataSource"), DateTimes.of((String)this.getStringValue("createdTime")), DateTimes.of((String)this.getStringValue("startTime")), DateTimes.of((String)this.getStringValue("endTime")), this.getStringValue("version"), ((Boolean)this.map.get((Object)"isCompacted")).booleanValue());
    }
}

