/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1FCVolumeSource;
import io.kubernetes.client.openapi.models.V1FCVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1FCVolumeSourceFluentImpl<A extends V1FCVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1FCVolumeSourceFluent<A> {
    private String fsType;
    private Integer lun;
    private Boolean readOnly;
    private List<String> targetWWNs;
    private List<String> wwids;

    public V1FCVolumeSourceFluentImpl() {
    }

    public V1FCVolumeSourceFluentImpl(V1FCVolumeSource instance) {
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withLun(instance.getLun());
            this.withReadOnly(instance.getReadOnly());
            this.withTargetWWNs(instance.getTargetWWNs());
            this.withWwids(instance.getWwids());
        }
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A addToTargetWWNs(int index, String item) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargetWWNs(int index, String item) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargetWWNs(String ... items) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargetWWNs(Collection<String> items) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargetWWNs(String ... items) {
        for (String item : items) {
            if (this.targetWWNs == null) continue;
            this.targetWWNs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargetWWNs(Collection<String> items) {
        for (String item : items) {
            if (this.targetWWNs == null) continue;
            this.targetWWNs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    @Override
    public String getTargetWWN(int index) {
        return this.targetWWNs.get(index);
    }

    @Override
    public String getFirstTargetWWN() {
        return this.targetWWNs.get(0);
    }

    @Override
    public String getLastTargetWWN() {
        return this.targetWWNs.get(this.targetWWNs.size() - 1);
    }

    @Override
    public String getMatchingTargetWWN(Predicate<String> predicate) {
        for (String item : this.targetWWNs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTargetWWN(Predicate<String> predicate) {
        for (String item : this.targetWWNs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargetWWNs(List<String> targetWWNs) {
        if (targetWWNs != null) {
            this.targetWWNs = new ArrayList<String>();
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        } else {
            this.targetWWNs = null;
        }
        return (A)this;
    }

    @Override
    public A withTargetWWNs(String ... targetWWNs) {
        if (this.targetWWNs != null) {
            this.targetWWNs.clear();
            this._visitables.remove("targetWWNs");
        }
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetWWNs() {
        return this.targetWWNs != null && !this.targetWWNs.isEmpty();
    }

    @Override
    public A addToWwids(int index, String item) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(index, item);
        return (A)this;
    }

    @Override
    public A setToWwids(int index, String item) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.set(index, item);
        return (A)this;
    }

    @Override
    public A addToWwids(String ... items) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToWwids(Collection<String> items) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromWwids(String ... items) {
        for (String item : items) {
            if (this.wwids == null) continue;
            this.wwids.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWwids(Collection<String> items) {
        for (String item : items) {
            if (this.wwids == null) continue;
            this.wwids.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getWwids() {
        return this.wwids;
    }

    @Override
    public String getWwid(int index) {
        return this.wwids.get(index);
    }

    @Override
    public String getFirstWwid() {
        return this.wwids.get(0);
    }

    @Override
    public String getLastWwid() {
        return this.wwids.get(this.wwids.size() - 1);
    }

    @Override
    public String getMatchingWwid(Predicate<String> predicate) {
        for (String item : this.wwids) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWwid(Predicate<String> predicate) {
        for (String item : this.wwids) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWwids(List<String> wwids) {
        if (wwids != null) {
            this.wwids = new ArrayList<String>();
            for (String item : wwids) {
                this.addToWwids(item);
            }
        } else {
            this.wwids = null;
        }
        return (A)this;
    }

    @Override
    public A withWwids(String ... wwids) {
        if (this.wwids != null) {
            this.wwids.clear();
            this._visitables.remove("wwids");
        }
        if (wwids != null) {
            for (String item : wwids) {
                this.addToWwids(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWwids() {
        return this.wwids != null && !this.wwids.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1FCVolumeSourceFluentImpl that = (V1FCVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.targetWWNs, that.targetWWNs)) {
            return false;
        }
        return Objects.equals(this.wwids, that.wwids);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.targetWWNs != null && !this.targetWWNs.isEmpty()) {
            sb.append("targetWWNs:");
            sb.append(this.targetWWNs + ",");
        }
        if (this.wwids != null && !this.wwids.isEmpty()) {
            sb.append("wwids:");
            sb.append(this.wwids);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }
}

