/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.stages.JoinStage;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.logical.stages.OffsetLimitStage;
import org.apache.druid.msq.logical.stages.ReadStage;
import org.apache.druid.msq.logical.stages.SortStage;
import org.apache.druid.msq.logical.stages.UnnestStage;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.logical.DruidJoin;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rel.logical.DruidSort;
import org.apache.druid.sql.calcite.rule.logical.DruidUnnest;

public class DruidLogicalToQueryDefinitionTranslator {
    private PlannerContext plannerContext;

    public DruidLogicalToQueryDefinitionTranslator(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public LogicalStage translate(DruidLogicalNode relRoot) {
        DruidQueryGenerator.DruidNodeStack stack = new DruidQueryGenerator.DruidNodeStack(this.plannerContext);
        stack.push(relRoot);
        LogicalStage logicalStage = this.buildStageFor(stack);
        return logicalStage;
    }

    private LogicalStage buildStageFor(DruidQueryGenerator.DruidNodeStack stack) {
        Optional<ReadStage> stage;
        List<LogicalStage> inputStages = this.buildInputStages(stack);
        DruidLogicalNode node = stack.getNode();
        if (inputStages.size() == 0 && (stage = ReadStage.buildReadStage(stack)).isPresent()) {
            return stage.get();
        }
        if (inputStages.size() == 1) {
            LogicalStage inputStage = inputStages.get(0);
            LogicalStage newStage = inputStage.extendWith(stack);
            if (newStage != null) {
                return newStage;
            }
            newStage = this.makeSequenceStage(inputStage, stack);
            if (newStage != null) {
                return newStage;
            }
        } else {
            LogicalStage newStage = this.buildMultiInputStage(inputStages, stack);
            if (newStage != null) {
                return newStage;
            }
        }
        throw DruidException.defensive().build("Unable to process relNode[%s]", new Object[]{node});
    }

    private LogicalStage buildMultiInputStage(List<LogicalStage> inputStages, DruidQueryGenerator.DruidNodeStack stack) {
        if (stack.getNode() instanceof DruidJoin) {
            return JoinStage.buildJoinStage(inputStages, stack);
        }
        return null;
    }

    private LogicalStage makeSequenceStage(LogicalStage inputStage, DruidQueryGenerator.DruidNodeStack stack) {
        if (stack.getNode() instanceof DruidSort) {
            DruidSort sort = (DruidSort)stack.getNode();
            List orderBySpecs = DruidQuery.buildOrderByColumnSpecs((RowSignature)inputStage.getLogicalRowSignature(), (Sort)sort);
            List keyColumns = Lists.transform((List)orderBySpecs, KeyColumn::fromOrderByColumnSpec);
            SortStage sortStage = new SortStage(inputStage, keyColumns);
            if (sort.hasLimitOrOffset()) {
                return new OffsetLimitStage(sortStage, sort.getOffsetLimit());
            }
            return sortStage;
        }
        if (stack.getNode() instanceof DruidUnnest) {
            return UnnestStage.buildUnnestStage(inputStage, stack);
        }
        return new ReadStage(inputStage.getLogicalRowSignature(), LogicalInputSpec.of(inputStage)).extendWith(stack);
    }

    private List<LogicalStage> buildInputStages(DruidQueryGenerator.DruidNodeStack stack) {
        ArrayList<LogicalStage> inputStages = new ArrayList<LogicalStage>();
        List inputs = stack.getNode().getInputs();
        for (RelNode input : inputs) {
            stack.push((DruidLogicalNode)input, inputStages.size());
            inputStages.add(this.buildStageFor(stack));
            stack.pop();
        }
        return inputStages;
    }
}

