/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateCapacityReservationFleetRequest;
import com.amazonaws.services.ec2.model.ReservationFleetInstanceSpecification;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class CreateCapacityReservationFleetRequestMarshaller
implements Marshaller<Request<CreateCapacityReservationFleetRequest>, CreateCapacityReservationFleetRequest> {
    public Request<CreateCapacityReservationFleetRequest> marshall(CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest) {
        SdkInternalList createCapacityReservationFleetRequestTagSpecificationsList;
        if (createCapacityReservationFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCapacityReservationFleetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateCapacityReservationFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCapacityReservationFleetRequest.getAllocationStrategy() != null) {
            request.addParameter("AllocationStrategy", StringUtils.fromString((String)createCapacityReservationFleetRequest.getAllocationStrategy()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createCapacityReservationFleetRequest.getClientToken()));
        SdkInternalList createCapacityReservationFleetRequestInstanceTypeSpecificationsList = (SdkInternalList)createCapacityReservationFleetRequest.getInstanceTypeSpecifications();
        if (!createCapacityReservationFleetRequestInstanceTypeSpecificationsList.isEmpty() || !createCapacityReservationFleetRequestInstanceTypeSpecificationsList.isAutoConstruct()) {
            int instanceTypeSpecificationsListIndex = 1;
            for (ReservationFleetInstanceSpecification createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue : createCapacityReservationFleetRequestInstanceTypeSpecificationsList) {
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getInstanceType() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".InstanceType", StringUtils.fromString((String)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getInstanceType()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getInstancePlatform() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".InstancePlatform", StringUtils.fromString((String)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getInstancePlatform()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getWeight() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".Weight", StringUtils.fromDouble((Double)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getWeight()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getAvailabilityZone() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".AvailabilityZone", StringUtils.fromString((String)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getAvailabilityZone()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getAvailabilityZoneId() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".AvailabilityZoneId", StringUtils.fromString((String)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getAvailabilityZoneId()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getEbsOptimized() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean((Boolean)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getEbsOptimized()));
                }
                if (createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getPriority() != null) {
                    request.addParameter("InstanceTypeSpecification." + instanceTypeSpecificationsListIndex + ".Priority", StringUtils.fromInteger((Integer)createCapacityReservationFleetRequestInstanceTypeSpecificationsListValue.getPriority()));
                }
                ++instanceTypeSpecificationsListIndex;
            }
        }
        if (createCapacityReservationFleetRequest.getTenancy() != null) {
            request.addParameter("Tenancy", StringUtils.fromString((String)createCapacityReservationFleetRequest.getTenancy()));
        }
        if (createCapacityReservationFleetRequest.getTotalTargetCapacity() != null) {
            request.addParameter("TotalTargetCapacity", StringUtils.fromInteger((Integer)createCapacityReservationFleetRequest.getTotalTargetCapacity()));
        }
        if (createCapacityReservationFleetRequest.getEndDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate((Date)createCapacityReservationFleetRequest.getEndDate()));
        }
        if (createCapacityReservationFleetRequest.getInstanceMatchCriteria() != null) {
            request.addParameter("InstanceMatchCriteria", StringUtils.fromString((String)createCapacityReservationFleetRequest.getInstanceMatchCriteria()));
        }
        if (!(createCapacityReservationFleetRequestTagSpecificationsList = (SdkInternalList)createCapacityReservationFleetRequest.getTagSpecifications()).isEmpty() || !createCapacityReservationFleetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createCapacityReservationFleetRequestTagSpecificationsListValue : createCapacityReservationFleetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createCapacityReservationFleetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createCapacityReservationFleetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createCapacityReservationFleetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

