/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateNetworkInsightsPathRequest;
import com.amazonaws.services.ec2.model.PathRequestFilter;
import com.amazonaws.services.ec2.model.RequestFilterPortRange;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateNetworkInsightsPathRequestMarshaller
implements Marshaller<Request<CreateNetworkInsightsPathRequest>, CreateNetworkInsightsPathRequest> {
    public Request<CreateNetworkInsightsPathRequest> marshall(CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) {
        PathRequestFilter filterAtDestination;
        SdkInternalList createNetworkInsightsPathRequestTagSpecificationsList;
        if (createNetworkInsightsPathRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInsightsPathRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInsightsPath");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInsightsPathRequest.getSourceIp() != null) {
            request.addParameter("SourceIp", StringUtils.fromString((String)createNetworkInsightsPathRequest.getSourceIp()));
        }
        if (createNetworkInsightsPathRequest.getDestinationIp() != null) {
            request.addParameter("DestinationIp", StringUtils.fromString((String)createNetworkInsightsPathRequest.getDestinationIp()));
        }
        if (createNetworkInsightsPathRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)createNetworkInsightsPathRequest.getSource()));
        }
        if (createNetworkInsightsPathRequest.getDestination() != null) {
            request.addParameter("Destination", StringUtils.fromString((String)createNetworkInsightsPathRequest.getDestination()));
        }
        if (createNetworkInsightsPathRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createNetworkInsightsPathRequest.getProtocol()));
        }
        if (createNetworkInsightsPathRequest.getDestinationPort() != null) {
            request.addParameter("DestinationPort", StringUtils.fromInteger((Integer)createNetworkInsightsPathRequest.getDestinationPort()));
        }
        if (!(createNetworkInsightsPathRequestTagSpecificationsList = (SdkInternalList)createNetworkInsightsPathRequest.getTagSpecifications()).isEmpty() || !createNetworkInsightsPathRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createNetworkInsightsPathRequestTagSpecificationsListValue : createNetworkInsightsPathRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createNetworkInsightsPathRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createNetworkInsightsPathRequest.getClientToken()));
        PathRequestFilter filterAtSource = createNetworkInsightsPathRequest.getFilterAtSource();
        if (filterAtSource != null) {
            RequestFilterPortRange destinationPortRange;
            RequestFilterPortRange sourcePortRange;
            if (filterAtSource.getSourceAddress() != null) {
                request.addParameter("FilterAtSource.SourceAddress", StringUtils.fromString((String)filterAtSource.getSourceAddress()));
            }
            if ((sourcePortRange = filterAtSource.getSourcePortRange()) != null) {
                if (sourcePortRange.getFromPort() != null) {
                    request.addParameter("FilterAtSource.SourcePortRange.FromPort", StringUtils.fromInteger((Integer)sourcePortRange.getFromPort()));
                }
                if (sourcePortRange.getToPort() != null) {
                    request.addParameter("FilterAtSource.SourcePortRange.ToPort", StringUtils.fromInteger((Integer)sourcePortRange.getToPort()));
                }
            }
            if (filterAtSource.getDestinationAddress() != null) {
                request.addParameter("FilterAtSource.DestinationAddress", StringUtils.fromString((String)filterAtSource.getDestinationAddress()));
            }
            if ((destinationPortRange = filterAtSource.getDestinationPortRange()) != null) {
                if (destinationPortRange.getFromPort() != null) {
                    request.addParameter("FilterAtSource.DestinationPortRange.FromPort", StringUtils.fromInteger((Integer)destinationPortRange.getFromPort()));
                }
                if (destinationPortRange.getToPort() != null) {
                    request.addParameter("FilterAtSource.DestinationPortRange.ToPort", StringUtils.fromInteger((Integer)destinationPortRange.getToPort()));
                }
            }
        }
        if ((filterAtDestination = createNetworkInsightsPathRequest.getFilterAtDestination()) != null) {
            RequestFilterPortRange destinationPortRange;
            RequestFilterPortRange sourcePortRange;
            if (filterAtDestination.getSourceAddress() != null) {
                request.addParameter("FilterAtDestination.SourceAddress", StringUtils.fromString((String)filterAtDestination.getSourceAddress()));
            }
            if ((sourcePortRange = filterAtDestination.getSourcePortRange()) != null) {
                if (sourcePortRange.getFromPort() != null) {
                    request.addParameter("FilterAtDestination.SourcePortRange.FromPort", StringUtils.fromInteger((Integer)sourcePortRange.getFromPort()));
                }
                if (sourcePortRange.getToPort() != null) {
                    request.addParameter("FilterAtDestination.SourcePortRange.ToPort", StringUtils.fromInteger((Integer)sourcePortRange.getToPort()));
                }
            }
            if (filterAtDestination.getDestinationAddress() != null) {
                request.addParameter("FilterAtDestination.DestinationAddress", StringUtils.fromString((String)filterAtDestination.getDestinationAddress()));
            }
            if ((destinationPortRange = filterAtDestination.getDestinationPortRange()) != null) {
                if (destinationPortRange.getFromPort() != null) {
                    request.addParameter("FilterAtDestination.DestinationPortRange.FromPort", StringUtils.fromInteger((Integer)destinationPortRange.getFromPort()));
                }
                if (destinationPortRange.getToPort() != null) {
                    request.addParameter("FilterAtDestination.DestinationPortRange.ToPort", StringUtils.fromInteger((Integer)destinationPortRange.getToPort()));
                }
            }
        }
        return request;
    }
}

