/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.MediaAcceleratorInfo;
import com.amazonaws.services.ec2.model.MediaDeviceInfo;
import com.amazonaws.services.ec2.model.transform.MediaDeviceInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class MediaAcceleratorInfoStaxUnmarshaller
implements Unmarshaller<MediaAcceleratorInfo, StaxUnmarshallerContext> {
    private static MediaAcceleratorInfoStaxUnmarshaller instance;

    public MediaAcceleratorInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        MediaAcceleratorInfo mediaAcceleratorInfo = new MediaAcceleratorInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return mediaAcceleratorInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("accelerators", targetDepth)) {
                    mediaAcceleratorInfo.withAccelerators(new ArrayList<MediaDeviceInfo>());
                    continue;
                }
                if (context.testExpression("accelerators/item", targetDepth)) {
                    mediaAcceleratorInfo.withAccelerators(MediaDeviceInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalMediaMemoryInMiB", targetDepth)) continue;
                mediaAcceleratorInfo.setTotalMediaMemoryInMiB(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return mediaAcceleratorInfo;
    }

    public static MediaAcceleratorInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MediaAcceleratorInfoStaxUnmarshaller();
        }
        return instance;
    }
}

