/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.common.aws.FileSessionCredentialsProvider;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class LazyFileSessionCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCredentialsConfig config;
    private volatile @MonotonicNonNull FileSessionCredentialsProvider provider;

    public LazyFileSessionCredentialsProvider(AWSCredentialsConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"provider"})
    private FileSessionCredentialsProvider getUnderlyingProvider() {
        FileSessionCredentialsProvider syncedProvider = this.provider;
        if (syncedProvider == null) {
            AWSCredentialsConfig aWSCredentialsConfig = this.config;
            synchronized (aWSCredentialsConfig) {
                syncedProvider = this.provider;
                if (syncedProvider == null) {
                    this.provider = syncedProvider = new FileSessionCredentialsProvider(this.config.getFileSessionCredentials());
                }
            }
        }
        return syncedProvider;
    }

    public AWSCredentials getCredentials() {
        return this.getUnderlyingProvider().getCredentials();
    }

    public void refresh() {
        this.getUnderlyingProvider().refresh();
    }
}

