/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.logging;

import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.logging.NoOpLog;
import org.skife.jdbi.v2.tweak.SQLLog;

public abstract class FormattedLog
implements SQLLog {
    @Override
    public final void logSQL(long time, String sql) {
        if (this.isEnabled()) {
            this.log(String.format("statement:[%s] took %d millis", sql, time));
        }
    }

    protected abstract boolean isEnabled();

    protected abstract void log(String var1);

    @Override
    public final void logPreparedBatch(long time, String sql, int count) {
        if (this.isEnabled()) {
            this.log(String.format("prepared batch with %d parts:[%s] took %d millis", count, sql, time));
        }
    }

    @Override
    public final SQLLog.BatchLogger logBatch() {
        if (this.isEnabled()) {
            final StringBuilder builder = new StringBuilder();
            builder.append("batch:[");
            return new SQLLog.BatchLogger(){
                private boolean added = false;

                @Override
                public final void add(String sql) {
                    this.added = true;
                    builder.append("[").append(sql).append("], ");
                }

                @Override
                public final void log(long time) {
                    if (this.added) {
                        builder.delete(builder.length() - 2, builder.length());
                    }
                    builder.append("]");
                    FormattedLog.this.log(String.format("%s took %d millis", builder.toString(), time));
                }
            };
        }
        return NoOpLog.batch;
    }

    @Override
    public void logBeginTransaction(Handle h) {
        if (this.isEnabled()) {
            this.log(String.format("begin transaction on [%s]", h));
        }
    }

    @Override
    public void logCommitTransaction(long time, Handle h) {
        if (this.isEnabled()) {
            this.log(String.format("commit transaction on [%s] took %d millis", h, time));
        }
    }

    @Override
    public void logRollbackTransaction(long time, Handle h) {
        if (this.isEnabled()) {
            this.log(String.format("rollback transaction on [%s] took %d millis", h, time));
        }
    }

    @Override
    public void logObtainHandle(long time, Handle h) {
        if (this.isEnabled()) {
            this.log(String.format("Handle [%s] obtained in %d millis", h, time));
        }
    }

    @Override
    public void logReleaseHandle(Handle h) {
        if (this.isEnabled()) {
            this.log(String.format("Handle [%s] released", h));
        }
    }

    @Override
    public void logCheckpointTransaction(Handle h, String name) {
        if (this.isEnabled()) {
            this.log(String.format("checkpoint [%s] created on [%s]", name, h));
        }
    }

    @Override
    public void logReleaseCheckpointTransaction(Handle h, String name) {
        if (this.isEnabled()) {
            this.log(String.format("checkpoint [%s] on [%s] released", name, h));
        }
    }

    @Override
    public void logRollbackToCheckpoint(long time, Handle h, String checkpointName) {
        if (this.isEnabled()) {
            this.log(String.format("checkpoint [%s] on [%s] rolled back in %d millis", checkpointName, h, time));
        }
    }
}

