/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBClusterAutomatedBackupsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBClusterAutomatedBackupsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterAutomatedBackupsRequest>, DescribeDBClusterAutomatedBackupsRequest> {
    public Request<DescribeDBClusterAutomatedBackupsRequest> marshall(DescribeDBClusterAutomatedBackupsRequest describeDBClusterAutomatedBackupsRequest) {
        if (describeDBClusterAutomatedBackupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterAutomatedBackupsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterAutomatedBackups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterAutomatedBackupsRequest.getDbClusterResourceId() != null) {
            request.addParameter("DbClusterResourceId", StringUtils.fromString((String)describeDBClusterAutomatedBackupsRequest.getDbClusterResourceId()));
        }
        if (describeDBClusterAutomatedBackupsRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterAutomatedBackupsRequest.getDBClusterIdentifier()));
        }
        if (!describeDBClusterAutomatedBackupsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBClusterAutomatedBackupsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBClusterAutomatedBackupsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterAutomatedBackupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterAutomatedBackupsRequest.getMaxRecords()));
        }
        if (describeDBClusterAutomatedBackupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterAutomatedBackupsRequest.getMarker()));
        }
        return request;
    }
}

