/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBRecommendationRequest;
import com.amazonaws.services.rds.model.RecommendedActionUpdate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBRecommendationRequestMarshaller
implements Marshaller<Request<ModifyDBRecommendationRequest>, ModifyDBRecommendationRequest> {
    public Request<ModifyDBRecommendationRequest> marshall(ModifyDBRecommendationRequest modifyDBRecommendationRequest) {
        if (modifyDBRecommendationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBRecommendationRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBRecommendation");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBRecommendationRequest.getRecommendationId() != null) {
            request.addParameter("RecommendationId", StringUtils.fromString((String)modifyDBRecommendationRequest.getRecommendationId()));
        }
        if (modifyDBRecommendationRequest.getLocale() != null) {
            request.addParameter("Locale", StringUtils.fromString((String)modifyDBRecommendationRequest.getLocale()));
        }
        if (modifyDBRecommendationRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString((String)modifyDBRecommendationRequest.getStatus()));
        }
        if (!modifyDBRecommendationRequest.getRecommendedActionUpdates().isEmpty() || !((SdkInternalList)modifyDBRecommendationRequest.getRecommendedActionUpdates()).isAutoConstruct()) {
            SdkInternalList recommendedActionUpdatesList = (SdkInternalList)modifyDBRecommendationRequest.getRecommendedActionUpdates();
            int recommendedActionUpdatesListIndex = 1;
            for (RecommendedActionUpdate recommendedActionUpdatesListValue : recommendedActionUpdatesList) {
                if (recommendedActionUpdatesListValue != null) {
                    if (recommendedActionUpdatesListValue.getActionId() != null) {
                        request.addParameter("RecommendedActionUpdates.member." + recommendedActionUpdatesListIndex + ".ActionId", StringUtils.fromString((String)recommendedActionUpdatesListValue.getActionId()));
                    }
                    if (recommendedActionUpdatesListValue.getStatus() != null) {
                        request.addParameter("RecommendedActionUpdates.member." + recommendedActionUpdatesListIndex + ".Status", StringUtils.fromString((String)recommendedActionUpdatesListValue.getStatus()));
                    }
                }
                ++recommendedActionUpdatesListIndex;
            }
        }
        return request;
    }
}

