/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.quantilescommon.GenericInequalitySearch;
import org.apache.datasketches.quantilescommon.GenericSortedView;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public class KllItemsSketchSortedView<T>
implements GenericSortedView<T> {
    private final Object[] quantiles;
    private final long[] cumWeights;
    private final long totalN;
    private final T minItem;
    private final Comparator<? super T> comp;

    KllItemsSketchSortedView(T[] quantiles, long[] cumWeights, long totalN, T minItem, Comparator<? super T> comparator) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
        this.minItem = minItem;
        this.comp = comparator;
    }

    KllItemsSketchSortedView(KllItemsSketch<T> sk) {
        this.totalN = sk.getN();
        this.minItem = sk.getMinItem();
        Object[] srcQuantiles = sk.getTotalItemsArray();
        int[] srcLevels = sk.levelsArr;
        int srcNumLevels = sk.getNumLevels();
        this.comp = sk.comparator;
        if (this.totalN == 0L) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (!sk.isLevelZeroSorted()) {
            Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1], this.comp);
            if (!sk.hasMemory()) {
                sk.setLevelZeroSorted(true);
            }
        }
        int numQuantiles = srcLevels[srcNumLevels] - srcLevels[0];
        this.quantiles = new Object[numQuantiles];
        this.cumWeights = new long[numQuantiles];
        this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.comp);
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        int len;
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.comp);
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = len = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        long naturalRank = searchCrit == QuantileSearchCriteria.INCLUSIVE ? (long)Math.ceil(rank * (double)this.totalN) : (long)Math.floor(rank * (double)this.totalN);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return (T)this.quantiles[this.quantiles.length - 1];
        }
        return (T)this.quantiles[index];
    }

    @Override
    public T[] getQuantiles() {
        Object[] quants = (Object[])Array.newInstance(this.minItem.getClass(), this.quantiles.length);
        System.arraycopy(this.quantiles, 0, quants, 0, this.quantiles.length);
        return quants;
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        GenericInequalitySearch.Inequality crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? GenericInequalitySearch.Inequality.LE : GenericInequalitySearch.Inequality.LT;
        int index = GenericInequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit, this.comp);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public KllItemsSketchSortedViewIterator<T> iterator() {
        return new KllItemsSketchSortedViewIterator<Object>(this.quantiles, this.cumWeights);
    }

    private void populateFromSketch(Object[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
        int[] myLevels = new int[srcNumLevels + 1];
        int offset = srcLevels[0];
        System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
        int srcLevel = 0;
        int dstLevel = 0;
        long weight = 1L;
        while (srcLevel < srcNumLevels) {
            int fromIndex = srcLevels[srcLevel] - offset;
            int toIndex = srcLevels[srcLevel + 1] - offset;
            if (fromIndex < toIndex) {
                Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                myLevels[dstLevel] = fromIndex;
                myLevels[dstLevel + 1] = toIndex;
                ++dstLevel;
            }
            ++srcLevel;
            weight *= 2L;
        }
        int numLevels = dstLevel;
        KllItemsSketchSortedView.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels, this.comp);
        KllHelper.convertToCumulative(this.cumWeights);
    }

    private static <T> void blockyTandemMergeSort(Object[] quantiles, long[] weights, int[] levels, int numLevels, Comparator<? super T> comp) {
        if (numLevels == 1) {
            return;
        }
        Object[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllItemsSketchSortedView.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels, comp);
    }

    private static <T> void blockyTandemMergeSortRecursion(Object[] quantilesSrc, long[] weightsSrc, Object[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels, Comparator<? super T> comp) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllItemsSketchSortedView.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1, comp);
        KllItemsSketchSortedView.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2, comp);
        KllItemsSketchSortedView.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2, comp);
    }

    private static <T> void tandemMerge(Object[] quantilesSrc, long[] weightsSrc, Object[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2, Comparator<? super T> comp) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (Util.lt(quantilesSrc[iSrc1], quantilesSrc[iSrc2], comp)) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    public static final class KllItemsSketchSortedViewIterator<T>
    extends GenericSortedViewIterator<T> {
        KllItemsSketchSortedViewIterator(T[] quantiles, long[] cumWeights) {
            super(quantiles, cumWeights);
        }
    }
}

