/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.joda.time.Period;

class AvaticaServerConfig {
    public static int DEFAULT_MAX_CONNECTIONS = 25;
    public static int DEFAULT_MAX_STATEMENTS_PER_CONNECTION = 4;
    public static Period DEFAULT_CONNECTION_IDLE_TIMEOUT = new Period((Object)"PT5M");
    public static int DEFAULT_MIN_ROWS_PER_FRAME = 100;
    public static int DEFAULT_MAX_ROWS_PER_FRAME = 5000;
    public static int DEFAULT_FETCH_TIMEOUT_MS = 5000;
    @JsonProperty
    public int maxConnections = DEFAULT_MAX_CONNECTIONS;
    @JsonProperty
    public int maxStatementsPerConnection = DEFAULT_MAX_STATEMENTS_PER_CONNECTION;
    @JsonProperty
    public Period connectionIdleTimeout = DEFAULT_CONNECTION_IDLE_TIMEOUT;
    @JsonProperty
    public int minRowsPerFrame = DEFAULT_MIN_ROWS_PER_FRAME;
    @JsonProperty
    public int maxRowsPerFrame = DEFAULT_MAX_ROWS_PER_FRAME;
    @JsonProperty
    public int fetchTimeoutMs = DEFAULT_FETCH_TIMEOUT_MS;

    AvaticaServerConfig() {
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxStatementsPerConnection() {
        return this.maxStatementsPerConnection;
    }

    public Period getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public int getMaxRowsPerFrame() {
        return this.maxRowsPerFrame;
    }

    public int getMinRowsPerFrame() {
        Preconditions.checkArgument((this.minRowsPerFrame > 0 ? 1 : 0) != 0, (Object)"'druid.sql.avatica.minRowsPerFrame' must be set to a value greater than 0");
        if (this.maxRowsPerFrame > 0) {
            return Math.min(this.getMaxRowsPerFrame(), this.minRowsPerFrame);
        }
        return this.minRowsPerFrame;
    }

    public int getFetchTimeoutMs() {
        return this.fetchTimeoutMs;
    }
}

