/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;

public abstract class CollectComparisons<BaseType, ComparisonType extends BaseType, CollectedType extends BaseType, CollectionKey, CollectionElementType, CollectionType extends Collection<CollectionElementType>> {
    private final List<BaseType> orExprs;
    private List<BaseType> retVal;

    protected CollectComparisons(List<BaseType> orExprs) {
        this.orExprs = orExprs;
    }

    public List<BaseType> collect() {
        if (this.retVal != null) {
            return this.retVal;
        }
        IntOpenHashSet orExprsToRemove = null;
        LinkedHashMap<Pair, List> collectMap = new LinkedHashMap<Pair, List>();
        for (int orExprIndex = 0; orExprIndex < this.orExprs.size(); ++orExprIndex) {
            Object selector;
            Object refKey;
            BaseType orExpr = this.orExprs.get(orExprIndex);
            Pair<ComparisonType, List<BaseType>> selectorFound = this.getCollectibleComparison(orExpr);
            if (selectorFound == null || (refKey = this.getCollectionKey(selector = selectorFound.lhs)) == null) continue;
            List comparisonList = collectMap.computeIfAbsent(Pair.of((Object)refKey, (Object)((List)selectorFound.rhs)), k -> new ArrayList());
            comparisonList.add(ObjectIntPair.of((Object)selector, (int)orExprIndex));
        }
        for (Map.Entry entry : collectMap.entrySet()) {
            List andExprs;
            Object subEntry2;
            List comparisonList = (List)entry.getValue();
            CollectionType values = this.makeCollection();
            for (Object subEntry2 : comparisonList) {
                Object selector = subEntry2.first();
                values.addAll(this.getMatchValues(selector));
            }
            CollectedType collected = this.makeCollectedComparison(((Pair)entry.getKey()).lhs, values);
            if (collected == null) continue;
            subEntry2 = comparisonList.iterator();
            while (subEntry2.hasNext()) {
                ObjectIntPair subEntry3 = (ObjectIntPair)subEntry2.next();
                int originalIndex = subEntry3.rightInt();
                if (orExprsToRemove == null) {
                    orExprsToRemove = new IntOpenHashSet();
                }
                orExprsToRemove.add(originalIndex);
            }
            if (this.retVal == null) {
                this.retVal = new ArrayList<BaseType>();
            }
            if ((andExprs = (List)((Pair)entry.getKey()).rhs).isEmpty()) {
                this.retVal.add(collected);
                continue;
            }
            ArrayList<CollectedType> allComparisons = new ArrayList<CollectedType>(andExprs.size() + 1);
            allComparisons.addAll(andExprs);
            allComparisons.add(collected);
            this.retVal.add(this.makeAnd(allComparisons));
        }
        if (this.retVal == null) {
            this.retVal = this.orExprs;
        } else {
            for (int i = 0; i < this.orExprs.size(); ++i) {
                if (orExprsToRemove != null && orExprsToRemove.contains(i)) continue;
                this.retVal.add(this.orExprs.get(i));
            }
        }
        return this.retVal;
    }

    @Nullable
    protected abstract Pair<ComparisonType, List<BaseType>> getCollectibleComparison(BaseType var1);

    protected abstract CollectionType makeCollection();

    @Nullable
    protected abstract CollectionKey getCollectionKey(ComparisonType var1);

    protected abstract Set<CollectionElementType> getMatchValues(ComparisonType var1);

    @Nullable
    protected abstract CollectedType makeCollectedComparison(CollectionKey var1, CollectionType var2);

    protected abstract BaseType makeAnd(List<BaseType> var1);
}

