/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.RowSignatures;

public abstract class DruidTable
implements TranslatableTable {
    private final RowSignature rowSignature;

    public DruidTable(RowSignature rowSignature) {
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
    }

    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public abstract DataSource getDataSource();

    public abstract boolean isJoinable();

    public abstract boolean isBroadcast();

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return RowSignatures.toRelDataType(this.getRowSignature(), typeFactory);
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidTable that = (DruidTable)o;
        if (!Objects.equals(this.getDataSource(), that.getDataSource())) {
            return false;
        }
        return Objects.equals(this.rowSignature, that.rowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.getDataSource(), this.rowSignature);
    }

    public String toString() {
        return "DruidTable{dataSource=" + this.getDataSource() + ", rowSignature=" + this.rowSignature + "}";
    }
}

