/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.AutoValue_HttpJsonCallOptions;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.protobuf.TypeRegistry;
import java.time.Duration;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

@AutoValue
public abstract class HttpJsonCallOptions {
    public static final HttpJsonCallOptions DEFAULT = HttpJsonCallOptions.newBuilder().build();

    @Nullable
    public abstract Duration getTimeout();

    @Nullable
    public abstract Instant getDeadline();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TypeRegistry getTypeRegistry();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_HttpJsonCallOptions.Builder();
    }

    public HttpJsonCallOptions merge(HttpJsonCallOptions inputOptions) {
        TypeRegistry newTypeRegistry;
        Credentials newCredentials;
        Duration newTimeout;
        if (inputOptions == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        Instant newDeadline = inputOptions.getDeadline();
        if (newDeadline != null) {
            builder.setDeadline(newDeadline);
        }
        if (inputOptions.getTimeout() != null && (newTimeout = Duration.ofMillis(inputOptions.getTimeout().toMillis())) != null) {
            builder.setTimeout(newTimeout);
        }
        if ((newCredentials = inputOptions.getCredentials()) != null) {
            builder.setCredentials(newCredentials);
        }
        if ((newTypeRegistry = inputOptions.getTypeRegistry()) != null) {
            builder.setTypeRegistry(newTypeRegistry);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTimeout(Duration var1);

        public abstract Builder setDeadline(Instant var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTypeRegistry(TypeRegistry var1);

        public abstract HttpJsonCallOptions build();
    }
}

