/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;

public class QueueNonBlockingPool<T>
implements NonBlockingPool<T> {
    private final BlockingQueue<T> queue;

    public QueueNonBlockingPool(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public ResourceHolder<T> take() {
        Object item = this.queue.poll();
        if (item == null) {
            throw new NoSuchElementException("No items available");
        }
        return new ReferenceCountingResourceHolder(item, () -> this.queue.add(item));
    }

    public int availableCount() {
        return this.queue.size();
    }
}

