/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.base.Preconditions;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.ComplexFieldReader;
import org.apache.druid.frame.field.DoubleArrayFieldReader;
import org.apache.druid.frame.field.DoubleFieldReader;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FloatArrayFieldReader;
import org.apache.druid.frame.field.FloatFieldReader;
import org.apache.druid.frame.field.LongArrayFieldReader;
import org.apache.druid.frame.field.LongFieldReader;
import org.apache.druid.frame.field.StringArrayFieldReader;
import org.apache.druid.frame.field.StringFieldReader;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class FieldReaders {
    private FieldReaders() {
    }

    public static FieldReader create(String columnName, ColumnType columnType, FrameType frameType) {
        switch ((ValueType)((ColumnType)Preconditions.checkNotNull((Object)columnType, (Object)"columnType")).getType()) {
            case LONG: {
                return LongFieldReader.forPrimitive();
            }
            case FLOAT: {
                return FloatFieldReader.forPrimitive(frameType);
            }
            case DOUBLE: {
                return DoubleFieldReader.forPrimitive(frameType);
            }
            case STRING: {
                return new StringFieldReader();
            }
            case COMPLEX: {
                return ComplexFieldReader.createFromType(columnType);
            }
            case ARRAY: {
                switch ((ValueType)Preconditions.checkNotNull((Object)((ValueType)columnType.getElementType().getType()), (Object)"array elementType")) {
                    case STRING: {
                        return new StringArrayFieldReader();
                    }
                    case LONG: {
                        return new LongArrayFieldReader();
                    }
                    case FLOAT: {
                        return new FloatArrayFieldReader(frameType);
                    }
                    case DOUBLE: {
                        return new DoubleArrayFieldReader(frameType);
                    }
                }
                throw new UnsupportedColumnTypeException(columnName, columnType);
            }
        }
        throw new UnsupportedColumnTypeException(columnName, columnType);
    }
}

