/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.ByteRowKeyComparator;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ClusterBy {
    private final List<KeyColumn> columns;
    private final int bucketByCount;
    private final boolean sortable;

    @JsonCreator
    public ClusterBy(@JsonProperty(value="columns") List<KeyColumn> columns, @JsonProperty(value="bucketByCount") int bucketByCount) {
        this.columns = (List)Preconditions.checkNotNull(columns, (Object)"columns");
        this.bucketByCount = bucketByCount;
        if (bucketByCount < 0 || bucketByCount > columns.size()) {
            throw new IAE("Invalid bucketByCount [%d]", bucketByCount);
        }
        boolean sortable = true;
        for (int i = 0; i < columns.size(); ++i) {
            KeyColumn column = columns.get(i);
            if (i == 0) {
                sortable = column.order().sortable();
                continue;
            }
            if (sortable == column.order().sortable()) continue;
            throw new IAE("Cannot mix sortable and unsortable key columns", new Object[0]);
        }
        this.sortable = sortable;
    }

    public static ClusterBy none() {
        return new ClusterBy(Collections.emptyList(), 0);
    }

    @JsonProperty
    public List<KeyColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getBucketByCount() {
        return this.bucketByCount;
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean sortable() {
        return this.sortable;
    }

    public RowKeyReader keyReader(ColumnInspector inspector, FrameType frameType) {
        RowSignature.Builder newSignature = RowSignature.builder();
        for (KeyColumn keyColumn : this.columns) {
            String columnName = keyColumn.columnName();
            ColumnCapabilities capabilities = inspector.getColumnCapabilities(columnName);
            ColumnType columnType = ((ColumnCapabilities)Preconditions.checkNotNull((Object)capabilities, (String)"Type for column [%s]", (Object)columnName)).toColumnType();
            newSignature.add(columnName, columnType);
        }
        return RowKeyReader.create(newSignature.build(), frameType);
    }

    public Comparator<RowKey> keyComparator(RowSignature rowSignature) {
        return RowKeyComparator.create(this.columns, rowSignature);
    }

    public Comparator<byte[]> byteKeyComparator(RowSignature rowSignature) {
        return ByteRowKeyComparator.create(this.columns, rowSignature);
    }

    public Comparator<RowKey> bucketComparator(RowSignature rowSignature) {
        if (this.bucketByCount == 0) {
            return Comparators.alwaysEqual();
        }
        return RowKeyComparator.create(this.columns.subList(0, this.bucketByCount), rowSignature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterBy clusterBy = (ClusterBy)o;
        return this.bucketByCount == clusterBy.bucketByCount && Objects.equals(this.columns, clusterBy.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.bucketByCount);
    }

    public String toString() {
        return "ClusterBy{columns=" + this.columns + ", bucketByCount=" + this.bucketByCount + "}";
    }
}

