/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;

public class KeyColumn {
    private final String columnName;
    private final KeyOrder order;

    @JsonCreator
    public KeyColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="order") KeyOrder order) {
        if (columnName == null || columnName.isEmpty()) {
            throw new IAE("Cannot have null or empty column name", new Object[0]);
        }
        this.columnName = columnName;
        this.order = order;
    }

    @JsonProperty
    public String columnName() {
        return this.columnName;
    }

    @JsonProperty
    public KeyOrder order() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyColumn keyColumn = (KeyColumn)o;
        return Objects.equals(this.columnName, keyColumn.columnName) && this.order == keyColumn.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.order});
    }

    public String toString() {
        return StringUtils.format("%s%s", this.columnName, this.order == KeyOrder.NONE ? "" : " " + this.order);
    }

    public static KeyColumn fromOrderByColumnSpec(OrderByColumnSpec orderByColumnSpec) {
        return new KeyColumn(orderByColumnSpec.getDimension(), KeyOrder.fromDirection(orderByColumnSpec.getDirection()));
    }
}

