/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;

public class FileOutputChannelFactory
implements OutputChannelFactory {
    private final File fileChannelsDirectory;
    private final int frameSize;
    private final ByteTracker byteTracker;

    public FileOutputChannelFactory(File fileChannelsDirectory, int frameSize, @Nullable ByteTracker byteTracker) {
        this.fileChannelsDirectory = fileChannelsDirectory;
        this.frameSize = frameSize;
        this.byteTracker = byteTracker == null ? ByteTracker.unboundedTracker() : byteTracker;
    }

    @Override
    public OutputChannel openChannel(int partitionNumber) throws IOException {
        FileUtils.mkdirp(this.fileChannelsDirectory);
        String fileName = StringUtils.format("part_%06d_%s", partitionNumber, UUID.randomUUID().toString());
        File file = new File(this.fileChannelsDirectory, fileName);
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open(Files.newByteChannel(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), ByteBuffer.allocate(Frame.compressionBufferSize(this.frameSize)), this.byteTracker));
        java.util.function.Supplier<ReadableFrameChannel> readableChannelSupplier = () -> ((Supplier)Suppliers.memoize(() -> {
            try {
                FrameFile frameFile = FrameFile.open(file, this.byteTracker, FrameFile.Flag.DELETE_ON_CLOSE);
                return new ReadableFileFrameChannel(frameFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).get();
        return OutputChannel.pair(writableChannel, ArenaMemoryAllocator.createOnHeap(this.frameSize), readableChannelSupplier, partitionNumber);
    }

    @Override
    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) throws IOException {
        FileUtils.mkdirp(this.fileChannelsDirectory);
        File file = new File(this.fileChannelsDirectory, name);
        WritableFrameFileChannel writableFrameFileChannel = new WritableFrameFileChannel(FrameFileWriter.open(Files.newByteChannel(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), ByteBuffer.allocate(Frame.compressionBufferSize(this.frameSize)), this.byteTracker));
        final java.util.function.Supplier<FrameFile> frameFileSupplier = () -> ((Supplier)Suppliers.memoize(() -> {
            try {
                return deleteAfterRead ? FrameFile.open(file, this.byteTracker, FrameFile.Flag.DELETE_ON_CLOSE) : FrameFile.open(file, this.byteTracker, new FrameFile.Flag[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).get();
        java.util.function.Supplier<PartitionedReadableFrameChannel> partitionedReadableFrameChannelSupplier = () -> ((Supplier)Suppliers.memoize(() -> new PartitionedReadableFrameChannel(){

            @Override
            public ReadableFrameChannel getReadableFrameChannel(int partitionNumber) {
                FrameFile fileHandle = (FrameFile)frameFileSupplier.get();
                fileHandle = fileHandle.newReference();
                return new ReadableFileFrameChannel(fileHandle, fileHandle.getPartitionStartFrame(partitionNumber), fileHandle.getPartitionStartFrame(partitionNumber + 1));
            }

            @Override
            public void close() throws IOException {
                ((FrameFile)frameFileSupplier.get()).close();
            }
        })).get();
        return PartitionedOutputChannel.pair(writableFrameFileChannel, ArenaMemoryAllocator.createOnHeap(this.frameSize), partitionedReadableFrameChannelSupplier);
    }

    @Override
    public OutputChannel openNilChannel(int partitionNumber) {
        return OutputChannel.nil(partitionNumber);
    }

    @Override
    public boolean isBuffered() {
        return true;
    }
}

