/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;

public class DimensionRangePartitionsSpec
implements DimensionBasedPartitionsSpec {
    public static final String NAME = "range";
    private final Integer targetRowsPerSegment;
    private final Integer maxRowsPerSegment;
    private final List<String> partitionDimensions;
    private final boolean assumeGrouped;
    private final int resolvedMaxRowPerSegment;

    @JsonCreator
    public DimensionRangePartitionsSpec(@JsonProperty(value="targetRowsPerSegment") @Nullable Integer targetRowsPerSegment, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="partitionDimensions") List<String> partitionDimensions, @JsonProperty(value="assumeGrouped") boolean assumeGrouped) {
        Preconditions.checkArgument((partitionDimensions != null ? 1 : 0) != 0, (Object)"partitionDimensions must be specified");
        this.partitionDimensions = partitionDimensions;
        this.assumeGrouped = assumeGrouped;
        Property<Integer> target = new Property<Integer>("targetRowsPerSegment", PartitionsSpec.resolveHistoricalNullIfNeeded(targetRowsPerSegment));
        Property<Integer> max = new Property<Integer>("maxRowsPerSegment", PartitionsSpec.resolveHistoricalNullIfNeeded(maxRowsPerSegment));
        Preconditions.checkArgument((target.getValue() == null != (max.getValue() == null) ? 1 : 0) != 0, (Object)("Exactly one of " + target.getName() + " or " + max.getName() + " must be present"));
        this.resolvedMaxRowPerSegment = DimensionRangePartitionsSpec.resolveMaxRowsPerSegment(target, max);
        this.targetRowsPerSegment = target.getValue();
        this.maxRowsPerSegment = max.getValue();
    }

    private static int resolveMaxRowsPerSegment(Property<Integer> targetRows, Property<Integer> maxRows) {
        if (targetRows.getValue() != null) {
            Preconditions.checkArgument((targetRows.getValue() > 0 ? 1 : 0) != 0, (Object)(targetRows.getName() + " must be greater than 0"));
            try {
                return Math.addExact(targetRows.getValue(), targetRows.getValue() / 2);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(targetRows.getName() + " is too large");
            }
        }
        Preconditions.checkArgument((maxRows.getValue() > 0 ? 1 : 0) != 0, (Object)(maxRows.getName() + " must be greater than 0"));
        return maxRows.getValue();
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTargetRowsPerSegment() {
        return this.targetRowsPerSegment;
    }

    @Override
    public SecondaryPartitionType getType() {
        return SecondaryPartitionType.RANGE;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Integer getMaxRowsPerSegment() {
        return this.resolvedMaxRowPerSegment;
    }

    @JsonProperty(value="maxRowsPerSegment")
    protected Integer getMaxRowsPerSegmentForJson() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public boolean isAssumeGrouped() {
        return this.assumeGrouped;
    }

    @Override
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        if (this.getPartitionDimensions() == null || this.getPartitionDimensions().isEmpty()) {
            return "partitionDimensions must be specified";
        }
        return "";
    }

    @Override
    public boolean needsDeterminePartitions(boolean useForHadoopTask) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionRangePartitionsSpec that = (DimensionRangePartitionsSpec)o;
        return this.assumeGrouped == that.assumeGrouped && this.resolvedMaxRowPerSegment == that.resolvedMaxRowPerSegment && Objects.equals(this.targetRowsPerSegment, that.targetRowsPerSegment) && Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.targetRowsPerSegment, this.maxRowsPerSegment, this.partitionDimensions, this.assumeGrouped, this.resolvedMaxRowPerSegment);
    }

    public String toString() {
        return "DimensionRangePartitionsSpec{targetRowsPerSegment=" + this.targetRowsPerSegment + ", maxRowsPerSegment=" + this.maxRowsPerSegment + ", partitionDimension='" + this.partitionDimensions + "', assumeGrouped=" + this.assumeGrouped + ", resolvedMaxRowPerSegment=" + this.resolvedMaxRowPerSegment + "}";
    }
}

