/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.druid.collections.StableLimitingSorter;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;

public class TopNSequence<T>
extends BaseSequence<T, Iterator<T>> {
    public TopNSequence(final Sequence<T> input, final Comparator<T> ordering, final int limit) {
        super(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                if (limit <= 0) {
                    return Collections.emptyIterator();
                }
                StableLimitingSorter sorter = new StableLimitingSorter(ordering, limit);
                input.accumulate(sorter, (theSorter, element) -> {
                    theSorter.add(element);
                    return theSorter;
                });
                return sorter.drain();
            }

            @Override
            public void cleanup(Iterator<T> rowIterator) {
            }
        });
    }
}

