/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ResultSerializationMode;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.OperatorSequence;
import org.apache.druid.query.operator.SequenceOperator;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.NullColumn;
import org.apache.druid.query.rowsandcols.semantic.FrameMaker;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryQueryToolChest
extends QueryToolChest<RowsAndColumns, WindowOperatorQuery> {
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public WindowOperatorQueryQueryToolChest(GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<RowsAndColumns> mergeResults(QueryRunner<RowsAndColumns> runner) {
        return new RowsAndColumnsSerializingQueryRunner((queryPlus, responseContext) -> {
            WindowOperatorQuery query = (WindowOperatorQuery)queryPlus.getQuery();
            List<OperatorFactory> opFactories = query.getOperators();
            if (opFactories.isEmpty()) {
                return runner.run(queryPlus, responseContext);
            }
            Supplier<Operator> opSupplier = () -> {
                Operator retVal = new SequenceOperator(runner.run(queryPlus.withQuery(query.withOperators(new ArrayList<OperatorFactory>())), responseContext));
                for (OperatorFactory operatorFactory : opFactories) {
                    retVal = operatorFactory.wrap(retVal);
                }
                return retVal;
            };
            return new OperatorSequence(opSupplier);
        });
    }

    @Override
    public QueryMetrics<? super WindowOperatorQuery> makeMetrics(WindowOperatorQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<RowsAndColumns, RowsAndColumns> makePreComputeManipulatorFn(WindowOperatorQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<RowsAndColumns> getResultTypeReference() {
        return new TypeReference<RowsAndColumns>(){};
    }

    @Override
    public RowSignature resultArraySignature(WindowOperatorQuery query) {
        return query.getRowSignature();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(WindowOperatorQuery query, Sequence<RowsAndColumns> resultSequence) {
        return resultSequence;
    }

    @Override
    public Optional<Sequence<FrameSignaturePair>> resultsAsFrames(WindowOperatorQuery query, Sequence<RowsAndColumns> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes) {
        return Optional.of(resultSequence);
    }

    private static class RowsAndColumnsSerializingQueryRunner
    implements QueryRunner {
        private final QueryRunner<RowsAndColumns> baseQueryRunner;

        private RowsAndColumnsSerializingQueryRunner(QueryRunner<RowsAndColumns> baseQueryRunner) {
            this.baseQueryRunner = baseQueryRunner;
        }

        public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
            WindowOperatorQuery query = (WindowOperatorQuery)queryPlus.getQuery();
            if (query.context().getBoolean("unravel", true)) {
                Sequence<RowsAndColumns> baseSequence = this.baseQueryRunner.run(queryPlus.withQuery(query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"unravel", (Object)false))), responseContext);
                ResultSerializationMode serializationMode = query.context().getEnum("serialization", ResultSerializationMode.class, ResultSerializationMode.ROWS);
                switch (serializationMode) {
                    case ROWS: {
                        return RowsAndColumnsSerializingQueryRunner.asRows(baseSequence, query);
                    }
                    case FRAMES: {
                        return RowsAndColumnsSerializingQueryRunner.asFrames(baseSequence);
                    }
                }
                throw DruidException.defensive("Serialization mode[%s] not supported", new Object[]{serializationMode});
            }
            return this.baseQueryRunner.run(queryPlus, responseContext);
        }

        private static Sequence asRows(Sequence<RowsAndColumns> baseSequence, WindowOperatorQuery query) {
            RowSignature rowSignature = query.getRowSignature();
            return baseSequence.flatMap(rac -> {
                ArrayList<Object[]> results = new ArrayList<Object[]>(rac.numRows());
                ColumnAccessor[] accessors = new ColumnAccessor[rowSignature.size()];
                int index = 0;
                for (String columnName : rowSignature.getColumnNames()) {
                    Column column = rac.findColumn(columnName);
                    if (column == null) {
                        ColumnType columnType = rowSignature.getColumnType(columnName).orElse(ColumnType.UNKNOWN_COMPLEX);
                        accessors[index] = new NullColumn.Accessor(columnType, rac.numRows());
                    } else {
                        accessors[index] = column.toAccessor();
                    }
                    ++index;
                }
                for (int i = 0; i < rac.numRows(); ++i) {
                    Object[] objArr = new Object[accessors.length];
                    for (int j = 0; j < accessors.length; ++j) {
                        objArr[j] = accessors[j].getObject(i);
                    }
                    results.add(objArr);
                }
                return Sequences.simple(results);
            });
        }

        private static Sequence asFrames(Sequence<RowsAndColumns> baseSequence) {
            return baseSequence.map(rac -> {
                FrameMaker frameMaker = FrameMaker.fromRAC(rac);
                return new FrameSignaturePair(frameMaker.toColumnBasedFrame(), frameMaker.computeSignature());
            });
        }
    }
}

