/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNCursorInspector;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.segment.Cursor;

public class HeapBasedTopNAlgorithm
extends BaseTopNAlgorithm<Aggregator[][], TopNColumnAggregatesProcessor, TopNParams> {
    private final TopNQuery query;

    public HeapBasedTopNAlgorithm(TopNQuery query, TopNCursorInspector cursorInspector) {
        super(cursorInspector);
        this.query = query;
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus<TopNColumnAggregatesProcessor> selectorPlus, Cursor cursor, CursorGranularizer granularizer) {
        return new TopNParams(selectorPlus, cursor, granularizer, Integer.MAX_VALUE);
    }

    @Override
    protected Aggregator[][] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        ColumnSelectorPlus<TopNColumnAggregatesProcessor> selectorPlus = params.getSelectorPlus();
        return selectorPlus.getColumnSelectorStrategy().getRowSelector(this.query, params, this.cursorInspector);
    }

    @Override
    protected Aggregator[][] updateDimValSelector(Aggregator[][] aggregators, int numProcessed, int numToProcess) {
        return aggregators;
    }

    @Override
    protected TopNColumnAggregatesProcessor makeDimValAggregateStore(TopNParams params) {
        ColumnSelectorPlus<TopNColumnAggregatesProcessor> selectorPlus = params.getSelectorPlus();
        return selectorPlus.getColumnSelectorStrategy();
    }

    @Override
    protected long scanAndAggregate(TopNParams params, Aggregator[][] rowSelector, TopNColumnAggregatesProcessor processor) {
        Cursor cursor = params.getCursor();
        ColumnSelectorPlus<TopNColumnAggregatesProcessor> selectorPlus = params.getSelectorPlus();
        processor.initAggregateStore();
        return processor.scanAndAggregate(this.query, selectorPlus.getSelector(), cursor, params.getGranularizer(), rowSelector);
    }

    @Override
    protected void updateResults(TopNParams params, Aggregator[][] aggregators, TopNColumnAggregatesProcessor processor, TopNResultBuilder resultBuilder) {
        processor.updateResults(resultBuilder);
    }

    @Override
    protected void resetAggregators(TopNColumnAggregatesProcessor processor) {
        processor.closeAggregators();
    }

    @Override
    public void cleanup(TopNParams params) {
    }
}

