/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.union;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryLogic;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.ToolChestBasedResultSerializedRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.union.UnionQuery;

public class UnionQueryLogic
implements QueryLogic {
    protected QueryRunnerFactoryConglomerate conglomerate;

    @Inject
    public void initialize(QueryRunnerFactoryConglomerate conglomerate) {
        this.conglomerate = conglomerate;
    }

    @Override
    public <T> QueryRunner<Object> entryPoint(Query<T> query, QuerySegmentWalker walker) {
        return new UnionQueryRunner((UnionQuery)query, this.conglomerate, walker);
    }

    static class UnionQueryRunner
    implements QueryRunner<Object> {
        private final QueryRunnerFactoryConglomerate conglomerate;
        private final QuerySegmentWalker walker;
        private final List<QueryRunner> runners;

        public UnionQueryRunner(UnionQuery query, QueryRunnerFactoryConglomerate conglomerate, QuerySegmentWalker walker) {
            this.conglomerate = conglomerate;
            this.walker = walker;
            this.runners = this.makeSubQueryRunners(query);
        }

        private List<QueryRunner> makeSubQueryRunners(UnionQuery unionQuery) {
            ArrayList<QueryRunner> runners = new ArrayList<QueryRunner>();
            for (Query<?> query : unionQuery.queries) {
                runners.add(this.buildRunnerFor(query));
            }
            return runners;
        }

        private QueryRunner<?> buildRunnerFor(Query<?> query) {
            QueryLogic queryLogic = this.conglomerate.getQueryLogic(query);
            if (queryLogic != null) {
                return queryLogic.entryPoint(query, this.walker);
            }
            return new ToolChestBasedResultSerializedRunner(query, this.walker, this.conglomerate.getToolChest(query));
        }

        @Override
        public Sequence<Object> run(QueryPlus<Object> queryPlus, ResponseContext responseContext) {
            UnionQuery unionQuery = queryPlus.unwrapQuery(UnionQuery.class);
            ArrayList seqs = new ArrayList();
            for (int i = 0; i < this.runners.size(); ++i) {
                Query<?> q = unionQuery.queries.get(i);
                QueryRunner runner = this.runners.get(i);
                Sequence<?> run = runner.run(queryPlus.withQuery(q), responseContext);
                seqs.add(run);
            }
            return Sequences.concat(seqs);
        }
    }
}

