/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;

public class FilteredCursorFactory
implements CursorFactory {
    private final CursorFactory delegate;
    @Nullable
    private final DimFilter filter;

    public FilteredCursorFactory(CursorFactory delegate, @Nullable DimFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        if (this.filter == null) {
            return this.delegate.makeCursorHolder(spec);
        }
        return this.delegate.makeCursorHolder(CursorBuildSpec.builder(spec).andFilter(this.filter.toFilter()).build());
    }

    @Override
    public RowSignature getRowSignature() {
        return this.delegate.getRowSignature();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(column);
    }
}

