/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.Order;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.NumericColumn;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.joda.time.DateTime;

public class QueryableIndexTimeBoundaryInspector
implements TimeBoundaryInspector {
    private final QueryableIndex index;
    private final boolean timeOrdered;
    private volatile @MonotonicNonNull DateTime minTime;
    private volatile @MonotonicNonNull DateTime maxTime;
    private volatile @MonotonicNonNull Integer numRows;

    private QueryableIndexTimeBoundaryInspector(QueryableIndex index, boolean timeOrdered) {
        this.index = index;
        this.timeOrdered = timeOrdered;
    }

    public static QueryableIndexTimeBoundaryInspector create(QueryableIndex index) {
        return new QueryableIndexTimeBoundaryInspector(index, Cursors.getTimeOrdering(index.getOrdering()) == Order.ASCENDING);
    }

    @Override
    public DateTime getMinTime() {
        if (this.minTime == null) {
            this.populateMinMaxTime();
        }
        return this.minTime;
    }

    @Override
    public DateTime getMaxTime() {
        if (this.maxTime == null) {
            this.populateMinMaxTime();
        }
        return this.maxTime;
    }

    @Override
    public boolean isMinMaxExact() {
        if (this.numRows == null) {
            this.numRows = this.index.getNumRows();
        }
        return this.timeOrdered && this.numRows > 0;
    }

    private void populateMinMaxTime() {
        if (this.isMinMaxExact()) {
            BaseColumnHolder columnHolder = this.index.getColumnHolder("__time");
            try (NumericColumn column = (NumericColumn)columnHolder.getColumn();){
                this.minTime = DateTimes.utc(column.getLongSingleValueRow(0));
                this.maxTime = DateTimes.utc(column.getLongSingleValueRow(column.length() - 1));
            }
        } else {
            this.minTime = this.index.getDataInterval().getStart();
            this.maxTime = this.index.getDataInterval().getEnd();
        }
    }
}

