/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeStrategy;

@Immutable
public interface TypeSignature<Type extends TypeDescriptor> {
    public Type getType();

    @Nullable
    public String getComplexTypeName();

    @Nullable
    public TypeSignature<Type> getElementType();

    public <T> TypeStrategy<T> getStrategy();

    default public <T> NullableTypeStrategy<T> getNullableStrategy() {
        return new NullableTypeStrategy<T>(this.getStrategy());
    }

    default public boolean is(Type candidate) {
        return Objects.equals(this.getType(), candidate);
    }

    default public boolean anyOf(Type ... types) {
        for (Type candidate : types) {
            if (!Objects.equals(this.getType(), candidate)) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    default public boolean isNumeric() {
        return this.getType().isNumeric();
    }

    @JsonIgnore
    default public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    @JsonIgnore
    default public boolean isArray() {
        return this.getType().isArray();
    }

    @JsonIgnore
    default public boolean isPrimitiveArray() {
        return this.getType().isArray() && this.getElementType() != null && this.getElementType().isPrimitive();
    }

    @JsonIgnore
    default public String asTypeString() {
        if (this.isArray()) {
            return StringUtils.format("ARRAY<%s>", this.getElementType());
        }
        String complexTypeName = this.getComplexTypeName();
        if (!this.isPrimitive()) {
            return complexTypeName == null ? "COMPLEX" : StringUtils.format("COMPLEX<%s>", complexTypeName);
        }
        return this.getType().toString();
    }
}

