/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter.cnf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.TrueFilter;

public class CalciteCnfHelper {
    public static Filter pull(Filter rex) {
        if (rex instanceof AndFilter) {
            LinkedHashSet<Filter> operands = ((AndFilter)rex).getFilters();
            return CalciteCnfHelper.and(CalciteCnfHelper.pullList(operands));
        }
        if (rex instanceof OrFilter) {
            LinkedHashSet<Filter> operands = ((OrFilter)rex).getFilters();
            Map<Filter, Filter> factors = CalciteCnfHelper.commonFactors(operands);
            if (factors.isEmpty()) {
                return CalciteCnfHelper.or(operands);
            }
            ArrayList<Filter> list = new ArrayList<Filter>();
            for (Filter operand : operands) {
                Filter removed = CalciteCnfHelper.removeFactor(factors, operand);
                list.add(removed);
            }
            if (list.isEmpty()) {
                return CalciteCnfHelper.and(factors.values());
            }
            if (list.size() == 1) {
                return CalciteCnfHelper.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of((Object)((Filter)list.get(0)))));
            }
            return CalciteCnfHelper.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of((Object)CalciteCnfHelper.or(list))));
        }
        return rex;
    }

    private static List<Filter> pullList(Collection<Filter> nodes) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter node : nodes) {
            Filter pulled = CalciteCnfHelper.pull(node);
            if (pulled instanceof AndFilter) {
                list.addAll(((AndFilter)pulled).getFilters());
                continue;
            }
            list.add(pulled);
        }
        return list;
    }

    private static Map<Filter, Filter> commonFactors(Collection<Filter> nodes) {
        LinkedHashMap<Filter, Filter> map = new LinkedHashMap<Filter, Filter>();
        int i = 0;
        for (Filter node : nodes) {
            if (i++ == 0) {
                for (Filter conjunction : CalciteCnfHelper.conjunctions(node)) {
                    map.put(conjunction, conjunction);
                }
                continue;
            }
            map.keySet().retainAll(CalciteCnfHelper.conjunctions(node));
        }
        return map;
    }

    private static Filter removeFactor(Map<Filter, Filter> factors, Filter node) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter operand : CalciteCnfHelper.conjunctions(node)) {
            if (factors.containsKey(operand)) continue;
            list.add(operand);
        }
        return CalciteCnfHelper.and(list);
    }

    private static Filter and(Iterable<? extends Filter> nodes) {
        return Filters.maybeAnd((List<Filter>)ImmutableList.copyOf(nodes)).orElse(TrueFilter.instance());
    }

    private static Filter or(Iterable<? extends Filter> nodes) {
        return Filters.maybeOr((List<Filter>)ImmutableList.copyOf(nodes)).orElse(FalseFilter.instance());
    }

    public static List<Filter> conjunctions(Filter rexPredicate) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        CalciteCnfHelper.decomposeConjunction(rexPredicate, list);
        return list;
    }

    public static void decomposeConjunction(Filter rexPredicate, List<Filter> rexList) {
        if (rexPredicate == null || rexPredicate instanceof TrueFilter) {
            return;
        }
        if (rexPredicate instanceof AndFilter) {
            for (Filter operand : ((AndFilter)rexPredicate).getFilters()) {
                CalciteCnfHelper.decomposeConjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    private CalciteCnfHelper() {
    }
}

