/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.transform.RowFunction;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.TransformedInputRow;

public class Transformer {
    private final Map<String, RowFunction> transforms = new HashMap<String, RowFunction>();
    private final ThreadLocal<Row> rowSupplierForValueMatcher = new ThreadLocal();
    private final ValueMatcher valueMatcher;

    Transformer(TransformSpec transformSpec) {
        for (Transform transform : transformSpec.getTransforms()) {
            this.transforms.put(transform.getName(), transform.getRowFunction());
        }
        this.valueMatcher = transformSpec.getFilter() != null ? transformSpec.getFilter().toFilter().makeMatcher(RowBasedColumnSelectorFactory.create(RowAdapters.standardRow(), this.rowSupplierForValueMatcher::get, RowSignature.empty(), false, false)) : null;
    }

    @Nullable
    public InputRow transform(@Nullable InputRow row) {
        if (row == null) {
            return null;
        }
        InputRow transformedRow = this.transforms.isEmpty() ? row : new TransformedInputRow(row, this.transforms);
        if (this.valueMatcher != null) {
            this.rowSupplierForValueMatcher.set(transformedRow);
            if (!this.valueMatcher.matches(false)) {
                return null;
            }
        }
        return transformedRow;
    }

    @Nullable
    public InputRowListPlusRawValues transform(@Nullable InputRowListPlusRawValues row) {
        InputRowListPlusRawValues inputRowListPlusRawValues;
        if (row == null) {
            return null;
        }
        if (this.transforms.isEmpty() || row.getInputRows() == null) {
            inputRowListPlusRawValues = row;
        } else {
            List<InputRow> originalRows = row.getInputRows();
            ArrayList<InputRow> transformedRows = new ArrayList<InputRow>(originalRows.size());
            for (InputRow originalRow : originalRows) {
                try {
                    transformedRows.add(new TransformedInputRow(originalRow, this.transforms));
                }
                catch (ParseException pe) {
                    return InputRowListPlusRawValues.of(row.getRawValues(), pe);
                }
            }
            inputRowListPlusRawValues = InputRowListPlusRawValues.ofList(row.getRawValuesList(), transformedRows);
        }
        if (this.valueMatcher != null && inputRowListPlusRawValues.getInputRows() != null) {
            int size = inputRowListPlusRawValues.getInputRows().size();
            ArrayList<InputRow> matchedRows = new ArrayList<InputRow>(size);
            ArrayList<Map<String, Object>> matchedVals = new ArrayList<Map<String, Object>>(size);
            List<InputRow> inputRows = inputRowListPlusRawValues.getInputRows();
            List<Map<String, Object>> inputVals = inputRowListPlusRawValues.getRawValuesList();
            for (int i = 0; i < size; ++i) {
                this.rowSupplierForValueMatcher.set(inputRows.get(i));
                if (!this.valueMatcher.matches(false)) continue;
                matchedRows.add(inputRows.get(i));
                matchedVals.add(inputVals.get(i));
            }
            return InputRowListPlusRawValues.ofList(matchedVals, matchedRows);
        }
        return inputRowListPlusRawValues;
    }
}

