/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.DataSegment;

public class SegmentStatusInCluster
implements Comparable<SegmentStatusInCluster> {
    private final boolean overshadowed;
    private final Integer replicationFactor;
    @JsonUnwrapped
    private final DataSegment dataSegment;
    private final Long numRows;
    private final boolean realtime;

    @JsonCreator
    public SegmentStatusInCluster(@JsonProperty(value="overshadowed") boolean overshadowed, @JsonProperty(value="replicationFactor") @Nullable Integer replicationFactor, @JsonProperty(value="numRows") @Nullable Long numRows, @JsonProperty(value="realtime") boolean realtime) {
        this(null, overshadowed, replicationFactor, numRows, realtime);
    }

    public SegmentStatusInCluster(DataSegment dataSegment, boolean overshadowed, Integer replicationFactor, Long numRows, boolean realtime) {
        this.dataSegment = dataSegment;
        this.overshadowed = overshadowed;
        this.replicationFactor = replicationFactor;
        this.numRows = numRows;
        this.realtime = realtime;
    }

    @JsonProperty
    public boolean isOvershadowed() {
        return this.overshadowed;
    }

    @JsonProperty
    public DataSegment getDataSegment() {
        return this.dataSegment;
    }

    @Nullable
    @JsonProperty
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    @Nullable
    @JsonProperty
    public Long getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public boolean isRealtime() {
        return this.realtime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentStatusInCluster that = (SegmentStatusInCluster)o;
        return this.overshadowed == that.overshadowed && this.realtime == that.realtime && Objects.equals(this.replicationFactor, that.replicationFactor) && Objects.equals(this.dataSegment, that.dataSegment) && Objects.equals(this.numRows, that.numRows);
    }

    public int hashCode() {
        return Objects.hash(this.overshadowed, this.replicationFactor, this.dataSegment, this.numRows, this.realtime);
    }

    @Override
    public int compareTo(SegmentStatusInCluster o) {
        return this.dataSegment.getId().compareTo(o.dataSegment.getId());
    }

    public String toString() {
        return "SegmentStatusInCluster{overshadowed=" + this.overshadowed + ", replicationFactor=" + this.replicationFactor + ", dataSegment=" + this.dataSegment + ", numRows=" + this.numRows + ", realtime=" + this.realtime + "}";
    }
}

