/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashPartitioner {
    private final ObjectMapper jsonMapper;
    private final HashPartitionFunction hashPartitionFunction;
    private final List<String> partitionDimensions;
    private final int numBuckets;

    HashPartitioner(ObjectMapper jsonMapper, HashPartitionFunction hashPartitionFunction, List<String> partitionDimensions, int numBuckets) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.hashPartitionFunction = (HashPartitionFunction)((Object)Preconditions.checkNotNull((Object)((Object)hashPartitionFunction), (Object)"hashPartitionFunction"));
        this.partitionDimensions = (List)Preconditions.checkNotNull(partitionDimensions, (Object)"partitionDimensions");
        this.numBuckets = numBuckets;
    }

    ShardSpecLookup createHashLookup(List<? extends ShardSpec> shardSpecs) {
        Preconditions.checkNotNull((Object)((Object)this.hashPartitionFunction), (Object)"hashPartitionFunction");
        return (timestamp, row) -> {
            int index = this.hash(timestamp, row);
            return (ShardSpec)shardSpecs.get(index);
        };
    }

    @VisibleForTesting
    int hash(long timestamp, InputRow inputRow) {
        return this.hashPartitionFunction.hash(HashBasedNumberedShardSpec.serializeGroupKey(this.jsonMapper, this.extractKeys(timestamp, inputRow)), this.numBuckets);
    }

    @VisibleForTesting
    List<Object> extractKeys(long timestamp, InputRow inputRow) {
        return HashPartitioner.extractKeys(this.partitionDimensions, timestamp, inputRow);
    }

    public static List<Object> extractKeys(List<String> partitionDimensions, long timestamp, InputRow inputRow) {
        if (partitionDimensions.isEmpty()) {
            return Rows.toGroupKey(timestamp, inputRow);
        }
        return Lists.transform(partitionDimensions, inputRow::getDimension);
    }
}

